/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.common;

import com.g4mesoft.access.common.GSIChunkHolderAccess;
import com.g4mesoft.core.GSVersion;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.module.tps.GSFlushingBlockEntityUpdatesPacket;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2626;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3222;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_9761;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3193.class})
public abstract class GSChunkHolderMixin
extends class_9761
implements GSIChunkHolderAccess {
    @Shadow
    @Final
    private class_5539 field_26929;
    @Shadow
    @Final
    private ShortSet[] field_25804;
    @Shadow
    @Final
    private class_3193.class_3897 field_17210;
    @Shadow
    private boolean field_25803;
    @Shadow
    @Final
    private BitSet field_13871;
    @Shadow
    @Final
    private BitSet field_13870;
    @Unique
    private static final GSVersion CORRECTED_PUSHING_VERSION = new GSVersion(1, 2, 2);
    @Unique
    private int gs_loopSectionIndex;
    @Unique
    private ShortSet[] gs_blockEntityUpdatesBySection;
    @Unique
    private boolean gs_pendingBlockEntityUpdates;

    @Shadow
    protected abstract void method_30311(List<class_3222> var1, class_1937 var2, class_2338 var3, class_2680 var4);

    @Shadow
    protected abstract void method_13992(List<class_3222> var1, class_2596<?> var2);

    @Shadow
    public abstract class_2818 method_16144();

    public GSChunkHolderMixin(class_1923 pos) {
        super(pos);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(class_1923 pos, int level, class_5539 world, class_3568 lightingProvider, class_3193.class_3896 levelUpdateListener, class_3193.class_3897 playersWatchingChunkProvider, CallbackInfo ci) {
        this.gs_blockEntityUpdatesBySection = new ShortSet[this.field_25804.length];
        this.gs_pendingBlockEntityUpdates = false;
    }

    @Inject(method={"flushUpdates"}, at={@At(value="HEAD")})
    private void onFlushUpdates(class_2818 chunk, CallbackInfo ci) {
        this.gs_loopSectionIndex = 0;
        if (this.gs_pendingBlockEntityUpdates) {
            GSServerController.getInstance().sendPacketToAll(new GSFlushingBlockEntityUpdatesPacket(true), CORRECTED_PUSHING_VERSION);
            if (!this.field_25803 && this.field_13870.isEmpty() && this.field_13871.isEmpty()) {
                for (int s = 0; s < this.gs_blockEntityUpdatesBySection.length; ++s) {
                    this.sendBlockEntityUpdates(chunk, s);
                }
            }
        }
    }

    @Inject(method={"flushUpdates"}, slice={@Slice(from=@At(value="INVOKE", ordinal=1, shift=At.Shift.AFTER, target="Ljava/util/BitSet;clear()V"))}, at={@At(value="FIELD", ordinal=1, shift=At.Shift.BEFORE, opcode=180, target="Lnet/minecraft/server/world/ChunkHolder;blockUpdatesBySection:[Lit/unimi/dsi/fastutil/shorts/ShortSet;")})
    private void onFlushUpdatesBlockUpdateLoop(class_2818 chunk, CallbackInfo ci) {
        if (this.gs_loopSectionIndex < this.gs_blockEntityUpdatesBySection.length) {
            this.sendBlockEntityUpdates(chunk, this.gs_loopSectionIndex++);
        }
    }

    @Inject(method={"flushUpdates"}, at={@At(value="RETURN")})
    private void onFlushUpdatesReturn(CallbackInfo ci) {
        if (this.gs_pendingBlockEntityUpdates) {
            GSServerController.getInstance().sendPacketToAll(new GSFlushingBlockEntityUpdatesPacket(false), CORRECTED_PUSHING_VERSION);
            this.gs_pendingBlockEntityUpdates = false;
        }
    }

    @Unique
    private void sendBlockEntityUpdates(class_2818 chunk, int sectionIndex) {
        ShortSet markedUpdates = this.gs_blockEntityUpdatesBySection[sectionIndex];
        if (markedUpdates != null) {
            int sectionCoord = this.field_26929.method_31604(sectionIndex);
            class_4076 sectionPos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)sectionCoord);
            List players = this.field_17210.method_17210(this.field_51868, false);
            ShortIterator shortIterator = markedUpdates.iterator();
            while (shortIterator.hasNext()) {
                short coord = (Short)shortIterator.next();
                class_2338 pos = sectionPos.method_30557(coord);
                class_2586 blockEntity = chunk.method_8321(pos);
                if (blockEntity == null) continue;
                if (blockEntity instanceof class_2669) {
                    this.method_13992(players, (class_2596<?>)class_2622.method_39026((class_2586)blockEntity, class_2586::method_38244));
                    continue;
                }
                class_2596 packet = blockEntity.method_38235();
                if (packet == null) continue;
                this.method_13992(players, packet);
            }
            this.gs_blockEntityUpdatesBySection[sectionIndex] = null;
        }
    }

    @Override
    public void gs_updateBlockImmediately(class_1937 world, class_2338 pos) {
        this.sendPacketToPlayersWatching((class_2596<?>)new class_2626((class_1922)world, pos.method_10062()), false);
        this.gs_updateBlockEntityImmediately(world, pos);
    }

    @Override
    public void gs_updateBlockEntityImmediately(class_1937 world, class_2338 pos) {
        List players = this.field_17210.method_17210(this.field_51868, false);
        this.method_30311(players, world, pos, world.method_8320(pos));
    }

    @Override
    public void gs_markBlockEntityUpdate(class_2338 blockPos) {
        class_2818 worldChunk = this.method_16144();
        if (worldChunk != null) {
            int sectionIndex = this.field_26929.method_31602(blockPos.method_10264());
            if (this.gs_blockEntityUpdatesBySection[sectionIndex] == null) {
                this.gs_pendingBlockEntityUpdates = true;
                this.gs_blockEntityUpdatesBySection[sectionIndex] = new ShortOpenHashSet();
            }
            this.gs_blockEntityUpdatesBySection[sectionIndex].add(class_4076.method_19454((class_2338)blockPos));
        }
    }

    @Override
    public void gs_sendToNearbyPlayers0(class_2596<?> packet) {
        this.sendPacketToPlayersWatching(packet, false);
    }

    @Unique
    private void sendPacketToPlayersWatching(class_2596<?> packet, boolean includeLazy) {
        this.method_13992(this.field_17210.method_17210(this.field_51868, includeLazy), packet);
    }
}

