/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.mixin.common;

import com.g4mesoft.access.common.GSIMinecraftServerAccess;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.debug.GSDebug;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class GSMinecraftServerMixin
implements GSIMinecraftServerAccess {
    @Shadow
    private long field_47139;
    @Shadow
    private long field_47140;
    @Shadow
    @Final
    private class_8915 field_47142;

    @Override
    public void gs_onTickrateChanged(float newTickrate, float oldTickrate) {
        long nsPrevTick = (long)(1.0E9 / (double)oldTickrate);
        long nsThisTick = (long)(1.0E9 / (double)newTickrate);
        if (nsPrevTick != nsThisTick) {
            long now = class_156.method_648();
            long dt = this.field_47139 - now;
            if (dt < nsPrevTick && nsPrevTick != 0L) {
                long delta = nsThisTick * dt / nsPrevTick;
                this.field_47139 = now + GSMathUtil.clamp((long)delta, (long)0L, (long)nsThisTick);
            } else {
                this.field_47139 = now + nsThisTick;
            }
            this.field_47140 = this.field_47139;
        }
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/server/MinecraftServer;createMetadata()Lnet/minecraft/server/ServerMetadata;")})
    private void onInitialized(CallbackInfo ci) {
        GSServerController controllerServer = GSServerController.getInstance();
        controllerServer.init((MinecraftServer)this);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        GSDebug.onServerTick();
        GSServerController.getInstance().tick(false);
    }

    @Inject(method={"shutdown"}, at={@At(value="RETURN")})
    private void onShutdown(CallbackInfo ci) {
        GSServerController.getInstance().onServerShutdown();
    }
}

