/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.tps;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSITickTimer;
import com.g4mesoft.module.tps.GSTpsModule;
import net.minecraft.class_156;

public class GSServerTickTimer
implements GSITickTimer {
    private static final float EXTRA_SYNC_DELAY = 5.0f;
    private static final float MIN_SYNC_DELAY = 10.0f;
    private static final float SYNC_DELAY_EASING_FACTOR = 0.25f;
    private static final float SYNC_AGGRESSION = 0.05f;
    private final GSTpsModule tpsModule;
    private float millisPerTick;
    private long prevTimeMillis;
    private float lastDuration;
    private float tickDelta;
    private int tickCount;
    private int ticksSinceLastPacket;
    private int syncTickInterval;
    private boolean syncReceived;
    private float syncDelay;

    public GSServerTickTimer(GSTpsModule tpsModule) {
        this.tpsModule = tpsModule;
        this.millisPerTick = 50.0f;
    }

    @Override
    public synchronized void init0(long initialTimeMillis) {
        this.prevTimeMillis = initialTimeMillis;
        this.lastDuration = 0.0f;
        this.tickDelta = 0.0f;
        this.ticksSinceLastPacket = 0;
        this.tickCount = 0;
    }

    @Override
    public synchronized void update0(long timeMillis) {
        long deltaMillis = timeMillis - this.prevTimeMillis;
        this.prevTimeMillis = timeMillis;
        this.lastDuration = (float)deltaMillis / this.getMillisPerTick0();
        this.tickDelta += this.lastDuration;
        this.tickCount = (int)this.tickDelta;
        this.tickDelta -= (float)this.tickCount;
        this.ticksSinceLastPacket += this.tickCount;
        if (this.ticksSinceLastPacket >= this.syncTickInterval * 2) {
            this.syncReceived = false;
        }
        this.updateSyncDelay(deltaMillis);
    }

    private void updateSyncDelay(long deltaMillis) {
        float targetDelay = Math.max(10.0f, (float)deltaMillis + 5.0f);
        this.syncDelay += (targetDelay - this.syncDelay) * 0.25f;
    }

    @Override
    public float getMillisPerTick0() {
        return this.millisPerTick;
    }

    public void setMillisPerTick(float millisPerTick) {
        this.millisPerTick = millisPerTick;
    }

    @Override
    public synchronized float getTickDelta0() {
        return this.tickDelta;
    }

    @Override
    public synchronized void setTickDelta0(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    @Override
    public synchronized int getTickCount0() {
        return this.tickCount;
    }

    @Override
    public synchronized void setTickCount0(int tickCount) {
        this.tickCount = tickCount;
    }

    @Override
    public synchronized float getLastDuration0() {
        return this.lastDuration;
    }

    @Override
    public long getPrevTimeMillis0() {
        return this.prevTimeMillis;
    }

    public synchronized void syncTimer(GSITickTimer timer) {
        if (this.tpsModule.cSyncTick.get().booleanValue() && this.shouldAdjustTickDelta()) {
            this.adjustTickDelta(timer);
        }
    }

    private boolean shouldAdjustTickDelta() {
        if (GSClientController.getInstance().isG4mespeedServer()) {
            return !this.tpsModule.isFrozen() && !this.tpsModule.isStepping() && !this.tpsModule.isSprinting();
        }
        return this.syncReceived && this.tpsModule.isSameTpsAsServer();
    }

    private void adjustTickDelta(GSITickTimer timer) {
        float targetTickDelta = this.tickDelta + this.syncDelay / timer.getMillisPerTick0();
        if ((targetTickDelta %= 1.0f) < 0.0f) {
            targetTickDelta += 1.0f;
        }
        float syncTickDelta = timer.getTickDelta0();
        int syncTickCount = timer.getTickCount0();
        float targetOffset = targetTickDelta - syncTickDelta;
        if (targetOffset < -0.5f) {
            targetOffset += 1.0f;
        } else if (targetOffset > 0.5f) {
            targetOffset -= 1.0f;
        }
        syncTickDelta += targetOffset * 0.05f;
        if (syncTickDelta < 0.0f) {
            if (syncTickCount > 0) {
                --syncTickCount;
                syncTickDelta += 1.0f;
            } else {
                syncTickDelta = 0.0f;
            }
        } else if (syncTickDelta >= 1.0f) {
            ++syncTickCount;
            syncTickDelta -= 1.0f;
        }
        timer.setTickDelta0(syncTickDelta);
        timer.setTickCount0(syncTickCount);
    }

    public synchronized void onSyncPacket(int syncTickInterval) {
        this.syncTickInterval = syncTickInterval;
        this.syncReceived = true;
        this.init0(class_156.method_658());
    }
}

