/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.tps;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.access.client.GSIAbstractClientPlayerEntityAccess;
import com.g4mesoft.access.common.GSIServerTickManagerAccess;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSIModuleManager;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.client.GSIClientModuleManager;
import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSKeyManager;
import com.g4mesoft.module.tps.GSETpsHotkeyType;
import com.g4mesoft.module.tps.GSITpsDependant;
import com.g4mesoft.module.tps.GSPlayerFixedMovementPacket;
import com.g4mesoft.module.tps.GSServerSyncPacket;
import com.g4mesoft.module.tps.GSServerTickTimer;
import com.g4mesoft.module.tps.GSServerTpsPacket;
import com.g4mesoft.module.tps.GSTickSprintUpdatePacket;
import com.g4mesoft.module.tps.GSTpsCommand;
import com.g4mesoft.module.tps.GSTpsHotkeyPacket;
import com.g4mesoft.module.tps.GSTpsMonitor;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.types.GSBooleanSetting;
import com.g4mesoft.setting.types.GSIntegerSetting;
import com.g4mesoft.ui.util.GSMathUtil;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8915;
import net.minecraft.class_8921;
import net.minecraft.server.MinecraftServer;

public class GSTpsModule
implements GSIModule,
GSISettingChangeListener {
    public static final float DEFAULT_TPS = 20.0f;
    public static final float MIN_TPS = 0.01f;
    public static final float MAX_TPS = Float.MAX_VALUE;
    public static final float MS_PER_SEC = 1000.0f;
    private static final long SERVER_TPS_INTERVAL = 2000L;
    private static final float TPS_INCREMENT_INTERVAL = 1.0f;
    private static final float TONE_MULTIPLIER = (float)Math.pow(2.0, 0.08333333333333333);
    public static final GSSettingCategory TPS_CATEGORY = new GSSettingCategory("tps");
    public static final GSSettingCategory BETTER_PISTONS_CATEGORY = new GSSettingCategory("betterPistons");
    public static final String KEY_CATEGORY = "tps";
    public static final int PISTON_ANIM_PAUSE_END = 0;
    public static final int PISTON_ANIM_PAUSE_MIDDLE = 1;
    public static final int PISTON_ANIM_PAUSE_BEGINNING = 2;
    public static final int PISTON_ANIM_NO_PAUSE = 3;
    public static final int AUTOMATIC_PISTON_RENDER_DISTANCE = -1;
    private static final int HOTKEY_MODE_DISABLED = 0;
    private static final int HOTKEY_MODE_CREATIVE = 1;
    private static final int HOTKEY_MODE_ALL = 2;
    private static final int HOTKEY_FEEDBACK_DISABLED = 0;
    private static final int HOTKEY_FEEDBACK_STATUS = 1;
    private static final int HOTKEY_FEEDBACK_CHAT = 2;
    public static final int TPS_LABEL_DISABLED = 0;
    public static final int TPS_LABEL_TOP_LEFT = 1;
    public static final int TPS_LABEL_TOP_CENTER = 2;
    public static final int TPS_LABEL_TOP_RIGHT = 3;
    public static final int PRETTY_SAND_DISABLED = 0;
    public static final int PRETTY_SAND_PERFORMANCE = 1;
    public static final int PRETTY_SAND_FIDELITY = 2;
    public static final DecimalFormat TPS_FORMAT = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final String TPS_CACHE_FILE_NAME = "tps_cache.txt";
    private float tps = 20.0f;
    private final List<GSITpsDependant> listeners;
    private int serverSyncTimer = 0;
    private GSTpsMonitor serverTpsMonitor;
    private long lastServerTpsTime;
    private boolean fixedMovementOnDefaultTps = false;
    private float serverTps = Float.NaN;
    private final GSServerTickTimer serverTimer = new GSServerTickTimer(this);
    private boolean sprinting = false;
    private GSIModuleManager manager = null;
    public final GSBooleanSetting cShiftPitch;
    public final GSBooleanSetting cSyncTick;
    public final GSIntegerSetting sSyncPacketInterval;
    public final GSIntegerSetting sTpsHotkeyMode;
    public final GSIntegerSetting sTpsHotkeyFeedback;
    public final GSBooleanSetting cNormalMovement;
    public final GSBooleanSetting cTweakerooFreecamHack;
    public final GSIntegerSetting cTpsLabel;
    public final GSBooleanSetting sBroadcastTps;
    public final GSBooleanSetting sRestoreTickrate;
    public final GSIntegerSetting sPrettySand;
    public final GSIntegerSetting cPistonAnimationType;
    public final GSBooleanSetting cCorrectPistonPushing;
    public final GSIntegerSetting cPistonRenderDistance;
    public final GSIntegerSetting sBlockEventDistance;
    public final GSBooleanSetting sParanoidMode;
    public final GSBooleanSetting sImmediateBlockBroadcast;

    public GSTpsModule() {
        this.listeners = new ArrayList<GSITpsDependant>();
        this.serverTpsMonitor = new GSTpsMonitor();
        this.lastServerTpsTime = class_156.method_658();
        this.cShiftPitch = new GSBooleanSetting("shiftPitch", true);
        this.cSyncTick = new GSBooleanSetting("syncTick", true);
        this.sSyncPacketInterval = new GSIntegerSetting("syncPacketInterval", 10, 1, 20);
        this.sTpsHotkeyMode = new GSIntegerSetting("hotkeyMode", 1, 0, 2);
        this.sTpsHotkeyFeedback = new GSIntegerSetting("hotkeyFeedback", 1, 0, 2);
        this.cNormalMovement = new GSBooleanSetting("normalMovement", true);
        this.cTweakerooFreecamHack = new GSBooleanSetting("tweakerooFreecamHack", true);
        this.cTpsLabel = new GSIntegerSetting("tpsLabel", 0, 0, 3);
        this.sBroadcastTps = new GSBooleanSetting("broadcastTps", true);
        this.sRestoreTickrate = new GSBooleanSetting("restoreTickrate", false);
        this.sPrettySand = new GSIntegerSetting("prettySand", 1, 0, 2);
        this.cPistonAnimationType = new GSIntegerSetting("pistonAnimationType", 0, 0, 3);
        this.cCorrectPistonPushing = new GSBooleanSetting("correctPistonPushing", false);
        this.cPistonRenderDistance = new GSIntegerSetting("pistonRenderDistance", -1, -1, 32);
        this.sBlockEventDistance = new GSIntegerSetting("blockEventDistance", 4, 0, 32);
        this.sParanoidMode = new GSBooleanSetting("paranoidMode", false);
        this.sImmediateBlockBroadcast = new GSBooleanSetting("immediateBlockBroadcast", false);
    }

    @Override
    public void init(GSIModuleManager manager) {
        this.manager = manager;
        this.resetTps();
        this.serverTpsMonitor.reset();
        manager.runOnServer(managerServer -> {
            if (this.sRestoreTickrate.get().booleanValue()) {
                try {
                    this.setTps(this.readTps(this.getTpsCacheFile()));
                }
                catch (IOException e) {
                    G4mespeedMod.GS_LOGGER.warn("Unable to read tps from cache.");
                }
            }
        });
    }

    @Override
    public void onClose() {
        this.clearTpsListeners();
        this.manager.runOnServer(serverManager -> {
            if (this.sRestoreTickrate.get().booleanValue()) {
                try {
                    this.writeTps(this.tps, this.getTpsCacheFile());
                }
                catch (IOException e) {
                    G4mespeedMod.GS_LOGGER.warn("Unable to write tps to cache.");
                }
            }
        });
        this.manager = null;
    }

    @Override
    public void registerClientSettings(GSSettingManager settings) {
        settings.registerSettings(TPS_CATEGORY, this.cShiftPitch, this.cSyncTick, this.cNormalMovement, G4mespeedMod.getTweakerooCompat().isCameraEntityRetreived() ? this.cTweakerooFreecamHack : null, this.cTpsLabel);
        this.cTweakerooFreecamHack.setEnabledInGui(this.cNormalMovement.get());
        settings.registerSettings(BETTER_PISTONS_CATEGORY, this.cPistonAnimationType, this.cCorrectPistonPushing, this.cPistonRenderDistance);
        settings.addChangeListener(this);
    }

    @Override
    public void registerHotkeys(GSKeyManager keyManager) {
        keyManager.registerKey("reset", KEY_CATEGORY, 77, GSETpsHotkeyType.RESET_TPS, this::onClientHotkey, GSEKeyEventType.PRESS);
        keyManager.registerKey("increment", KEY_CATEGORY, 46, GSETpsHotkeyType.INCREMENT_TPS, this::onClientHotkey, GSEKeyEventType.PRESS);
        keyManager.registerKey("decrement", KEY_CATEGORY, 44, GSETpsHotkeyType.DECREMENT_TPS, this::onClientHotkey, GSEKeyEventType.PRESS);
        keyManager.registerKey("double", KEY_CATEGORY, 75, GSETpsHotkeyType.DOUBLE_TPS, this::onClientHotkey, GSEKeyEventType.PRESS);
        keyManager.registerKey("halve", KEY_CATEGORY, 74, GSETpsHotkeyType.HALVE_TPS, this::onClientHotkey, GSEKeyEventType.PRESS);
    }

    @Override
    public void registerGlobalServerSettings(GSSettingManager settings) {
        settings.registerSettings(TPS_CATEGORY, this.sSyncPacketInterval, this.sBroadcastTps, this.sTpsHotkeyMode, this.sTpsHotkeyFeedback, this.sRestoreTickrate, this.sPrettySand);
        settings.registerSettings(BETTER_PISTONS_CATEGORY, this.sBlockEventDistance, this.sParanoidMode, this.sImmediateBlockBroadcast);
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        GSTpsCommand.registerCommand(dispatcher);
    }

    @Override
    public void tick(boolean paused) {
        this.manager.runOnServer(managerServer -> {
            long now;
            long serverTpsInterval;
            if (!paused && !this.isSprinting()) {
                ++this.serverSyncTimer;
                int syncInterval = this.sSyncPacketInterval.get();
                if (this.serverSyncTimer >= syncInterval) {
                    managerServer.sendPacketToAll(new GSServerSyncPacket(syncInterval));
                    this.serverSyncTimer = 0;
                }
            }
            this.serverTpsMonitor.update(1);
            if (this.sBroadcastTps.get().booleanValue() && ((serverTpsInterval = (now = class_156.method_658()) - this.lastServerTpsTime) < 0L || serverTpsInterval > 2000L)) {
                float averageTps = this.serverTpsMonitor.getAverageTps();
                managerServer.sendPacketToAll(new GSServerTpsPacket(averageTps));
                this.lastServerTpsTime = now;
            }
        });
    }

    @Override
    public void onJoinG4mespeedServer(GSExtensionInfo coreInfo) {
        this.sendFixedMovementPacket();
    }

    public void onServerTps(float serverTps) {
        this.serverTps = serverTps;
        this.lastServerTpsTime = class_156.method_658();
    }

    private void onClientHotkey(final GSETpsHotkeyType hotkeyType) {
        this.manager.runOnClient(new Consumer<GSIClientModuleManager>(){

            @Override
            @Environment(value=EnvType.CLIENT)
            public void accept(GSIClientModuleManager managerClient) {
                class_310 client = class_310.method_1551();
                boolean sneaking = client.field_1690.field_1832.method_1434();
                if (managerClient.isG4mespeedServer()) {
                    if (GSTpsModule.this.sTpsHotkeyMode.get() != 0) {
                        managerClient.sendPacket(new GSTpsHotkeyPacket(hotkeyType, sneaking));
                    }
                } else if (client.field_1761 != null) {
                    if (GSTpsModule.this.isGameModeAllowingHotkeys(client.field_1761.method_2920())) {
                        GSTpsModule.this.performHotkeyAction(hotkeyType, sneaking);
                        if (client.field_1705 != null) {
                            String formattedTps = TPS_FORMAT.format(GSTpsModule.this.tps);
                            class_5250 overlay = class_2561.method_43469((String)"play.info.clientTpsChanged", (Object[])new Object[]{formattedTps});
                            client.field_1705.method_1758((class_2561)overlay, false);
                        }
                    } else if (client.field_1705 != null) {
                        client.field_1705.method_1758((class_2561)class_2561.method_43471((String)"play.info.hotkeysDisallowed"), false);
                    }
                }
            }
        });
    }

    public void onPlayerHotkey(class_3222 player, GSETpsHotkeyType type, boolean sneaking) {
        if (this.sTpsHotkeyMode.get() != 0 && this.isPlayerAllowedTpsChange((class_1657)player)) {
            if (this.isGameModeAllowingHotkeys(player.field_13974.method_14257())) {
                float oldTps = this.tps;
                this.performHotkeyAction(type, sneaking);
                if (!GSMathUtil.equalsApproximate((float)oldTps, (float)this.tps)) {
                    this.manager.runOnServer(serverManager -> {
                        class_2561 name = player.method_5476();
                        String formattedTps = TPS_FORMAT.format(this.tps);
                        class_5250 feedbackText = class_2561.method_43469((String)"play.info.tpsChanged", (Object[])new Object[]{name, formattedTps});
                        for (class_3222 otherPlayer : serverManager.getAllPlayers()) {
                            if (!this.isPlayerAllowedTpsChange((class_1657)otherPlayer)) continue;
                            this.sendHotkeyFeedback(otherPlayer, (class_2561)feedbackText);
                        }
                    });
                }
            } else {
                this.sendHotkeyFeedback(player, (class_2561)class_2561.method_43471((String)"play.info.hotkeysDisallowed"));
            }
        }
    }

    private void sendHotkeyFeedback(class_3222 player, class_2561 feedbackText) {
        switch (this.sTpsHotkeyFeedback.get()) {
            case 0: {
                break;
            }
            case 1: {
                player.method_7353(feedbackText, true);
                break;
            }
            case 2: {
                player.method_7353(feedbackText, false);
                break;
            }
        }
    }

    public void performHotkeyAction(GSETpsHotkeyType type, boolean sneaking) {
        if (type == GSETpsHotkeyType.RESET_TPS) {
            this.resetTps();
            return;
        }
        switch (type) {
            case INCREMENT_TPS: {
                if (sneaking) {
                    this.setTps(this.tps * TONE_MULTIPLIER);
                    break;
                }
                this.setTps(this.tps + 1.0f);
                break;
            }
            case DECREMENT_TPS: {
                if (sneaking) {
                    this.setTps(this.tps / TONE_MULTIPLIER);
                    break;
                }
                this.setTps(this.tps - 1.0f);
                break;
            }
            case DOUBLE_TPS: {
                this.setTps(this.tps * 2.0f);
                break;
            }
            case HALVE_TPS: {
                this.setTps(this.tps / 2.0f);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void onDisconnectServer() {
        this.resetTps();
        this.serverTps = Float.NaN;
        this.sprinting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTpsListener(GSITpsDependant listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<GSITpsDependant> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            listener.tpsChanged(this.tps, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTpsListener(GSITpsDependant listener) {
        List<GSITpsDependant> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTpsListeners() {
        List<GSITpsDependant> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    public void resetTps() {
        this.setTps(20.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTps(float tps) {
        if (!GSMathUtil.equalsApproximate((float)(tps = GSMathUtil.clamp((float)tps, (float)0.01f, (float)Float.MAX_VALUE)), (float)this.tps)) {
            float oldTps = this.tps;
            this.tps = tps;
            List<GSITpsDependant> list = this.listeners;
            synchronized (list) {
                for (GSITpsDependant listener : this.listeners) {
                    listener.tpsChanged(tps, oldTps);
                }
            }
            this.manager.runOnServer(managerServer -> {
                MinecraftServer server = managerServer.getServer();
                class_8915 tickManager = server.method_54833();
                if (!((GSIServerTickManagerAccess)tickManager).gs_isUpdatingTps()) {
                    tickManager.method_54671(this.tps);
                }
                this.serverSyncTimer = this.sSyncPacketInterval.get();
                this.serverTpsMonitor.reset();
                this.lastServerTpsTime = class_156.method_658();
            });
        }
    }

    public boolean isGameModeAllowingHotkeys(class_1934 gameMode) {
        switch (this.sTpsHotkeyMode.get()) {
            case 1: {
                return gameMode == class_1934.field_9220 || gameMode == class_1934.field_9219;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAllowedTpsChange(class_1657 player) {
        return player.method_64475(2);
    }

    @Override
    public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
        if (setting == this.cNormalMovement) {
            this.sendFixedMovementPacket();
            this.cTweakerooFreecamHack.setEnabledInGui(this.cNormalMovement.get());
        }
    }

    private void sendFixedMovementPacket() {
        this.manager.runOnClient(clientManager -> clientManager.sendPacket(new GSPlayerFixedMovementPacket(this.cNormalMovement.get())));
    }

    public float getMsPerTick() {
        return 1000.0f / this.tps;
    }

    public float getTps() {
        return this.tps;
    }

    public boolean isDefaultTps() {
        return GSMathUtil.equalsApproximate((float)this.tps, (float)20.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private class_8921 getClientTickManager() {
        if (!this.manager.isClient()) {
            throw new IllegalStateException();
        }
        class_310 client = class_310.method_1551();
        return client.field_1687 != null ? client.field_1687.method_54719() : null;
    }

    @Environment(value=EnvType.CLIENT)
    private float getVanillaClientTps() {
        class_8921 tm = this.getClientTickManager();
        return tm != null ? tm.method_54748() : 20.0f;
    }

    public boolean isSameTpsAsServer() {
        return GSMathUtil.equalsApproximate((float)this.tps, (float)this.getVanillaClientTps());
    }

    public boolean isFrozen() {
        class_8921 tm = this.getClientTickManager();
        if (tm == null) {
            return false;
        }
        return tm.method_54754();
    }

    public boolean isStepping() {
        class_8921 tm = this.getClientTickManager();
        if (tm == null) {
            return false;
        }
        return tm.method_54752();
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private float readTps(File file) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            String line = br.readLine();
            if (line == null) throw new IOException("Tps file is empty");
            float f = Float.parseFloat(line);
            return f;
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid tps format", e);
        }
    }

    private void writeTps(float tps, File file) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bw.write(Float.toString(tps));
        }
    }

    private File getTpsCacheFile() {
        return new File(this.manager.getCacheFile(), TPS_CACHE_FILE_NAME);
    }

    @Environment(value=EnvType.CLIENT)
    public void onServerSyncPacket(int packetInterval) {
        this.serverTimer.onSyncPacket(packetInterval);
        this.serverTpsMonitor.update(packetInterval);
    }

    @Environment(value=EnvType.CLIENT)
    public float getServerTps() {
        if (this.sBroadcastTps.get().booleanValue() && Float.isFinite(this.serverTps)) {
            return this.serverTps;
        }
        return this.serverTpsMonitor.getAverageTps();
    }

    @Environment(value=EnvType.CLIENT)
    public GSServerTickTimer getServerTimer() {
        return this.serverTimer;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isMainPlayerFixedMovement() {
        class_746 player;
        return this.cNormalMovement.get() != false && (!this.isDefaultTps() || this.fixedMovementOnDefaultTps) && (player = GSClientController.getInstance().getPlayer()) != null && !player.method_5765();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isPlayerFixedMovement(class_742 player) {
        if (!this.isDefaultTps() || this.fixedMovementOnDefaultTps) {
            GSClientController controller = GSClientController.getInstance();
            if (player == controller.getPlayer()) {
                return this.isMainPlayerFixedMovement();
            }
            if (!controller.isG4mespeedServer()) {
                return GSMathUtil.equalsApproximate((float)this.getVanillaClientTps(), (float)20.0f);
            }
            return ((GSIAbstractClientPlayerEntityAccess)player).gs_isFixedMovement();
        }
        return false;
    }

    public boolean isFixedMovementOnDefaultTps() {
        return this.fixedMovementOnDefaultTps;
    }

    public void setFixedMovementOnDefaultTps(boolean fixedMovementOnDefaultTps) {
        this.fixedMovementOnDefaultTps = fixedMovementOnDefaultTps;
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientGameModeChanged(class_1934 gameMode) {
        GSClientController controller = GSClientController.getInstance();
        if (controller.isConnectedToServer() && !controller.isG4mespeedServer() && !this.isGameModeAllowingHotkeys(gameMode)) {
            this.setTps(this.getVanillaClientTps());
        }
    }

    public void onTickSprintChanged(boolean sprinting) {
        if (sprinting != this.sprinting) {
            this.sprinting = sprinting;
            this.manager.runOnServer(managerServer -> managerServer.sendPacketToAll(new GSTickSprintUpdatePacket(sprinting)));
        }
    }
}

