/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.module.translation;

import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.module.translation.GSTranslationCacheList;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSTranslationVersionsPacket
implements GSIPacket {
    private Map<GSExtensionUID, Integer> uidToVersion;

    public GSTranslationVersionsPacket() {
    }

    public GSTranslationVersionsPacket(Map<GSExtensionUID, GSTranslationCacheList> cacheLists) {
        this.uidToVersion = new HashMap<GSExtensionUID, Integer>();
        for (Map.Entry<GSExtensionUID, GSTranslationCacheList> entry : cacheLists.entrySet()) {
            this.uidToVersion.put(entry.getKey(), entry.getValue().getVersion());
        }
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        int n = buf.readInt();
        this.uidToVersion = new HashMap<GSExtensionUID, Integer>();
        while (n-- != 0) {
            GSExtensionUID uid = GSExtensionUID.read(buf);
            int version = buf.readInt();
            this.uidToVersion.put(uid, version);
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeInt(this.uidToVersion.size());
        for (Map.Entry<GSExtensionUID, Integer> entry : this.uidToVersion.entrySet()) {
            GSExtensionUID.write(buf, entry.getKey());
            buf.writeInt(entry.getValue());
        }
    }

    @Override
    public void handleOnServer(GSServerController controller, class_3222 player) {
        controller.getTranslationModule().onTranslationVersionsReceived(player, this.uidToVersion);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

