/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.registry;

import com.g4mesoft.registry.GSDuplicateRegisterException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class GSReferenceRegsitry<K, V> {
    private final Map<K, V> idToElement = new HashMap();
    private final Map<V, K> elementToId = new IdentityHashMap<V, K>();

    public void register(K id, V element) {
        if (this.idToElement.containsKey(id)) {
            throw new GSDuplicateRegisterException("Identifier is already registered: " + String.valueOf(id));
        }
        if (this.elementToId.containsKey(element)) {
            throw new GSDuplicateRegisterException("Element class is already registered: " + String.valueOf(element));
        }
        this.idToElement.put(id, element);
        this.elementToId.put(element, id);
    }

    public boolean containsIdentifier(K id) {
        return this.idToElement.containsKey(id);
    }

    public boolean containsElement(V element) {
        return this.elementToId.containsKey(element);
    }

    public K getIdentifier(V element) {
        return this.elementToId.get(element);
    }

    public V getElement(K id) {
        return this.idToElement.get(id);
    }

    public int getSize() {
        return this.idToElement.size();
    }
}

