/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.registry;

import com.g4mesoft.registry.GSDuplicateRegisterException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class GSSupplierRegistry<K, V> {
    private final Map<K, Supplier<? extends V>> idToSupplier = new HashMap<K, Supplier<? extends V>>();
    private final Map<Class<? extends V>, K> elementToId = new IdentityHashMap<Class<? extends V>, K>();

    public <T extends V> void register(K id, Class<T> elementClazz, Supplier<T> supplier) {
        if (this.idToSupplier.containsKey(id)) {
            throw new GSDuplicateRegisterException("Identifier is already registered: " + String.valueOf(id));
        }
        if (this.elementToId.containsKey(elementClazz)) {
            throw new GSDuplicateRegisterException("Element class is already registered: " + String.valueOf(elementClazz));
        }
        this.idToSupplier.put(id, supplier);
        this.elementToId.put((Class<K>)elementClazz, (Class<T>)id);
    }

    public boolean containsIdentifier(K id) {
        return this.idToSupplier.containsKey(id);
    }

    public <E extends V> boolean containsElement(E element) {
        Class<?> elementClazz = element.getClass();
        return this.containsElement(elementClazz);
    }

    public <E extends V> boolean containsElement(Class<E> elementClazz) {
        return this.elementToId.containsKey(elementClazz);
    }

    public <E extends V> K getIdentifier(E element) {
        Class<?> elementClazz = element.getClass();
        return this.getIdentifier(elementClazz);
    }

    public <E extends V> K getIdentifier(Class<E> elementClazz) {
        return this.elementToId.get(elementClazz);
    }

    public Supplier<? extends V> getSupplier(K id) {
        return this.idToSupplier.get(id);
    }

    public V createNewElement(K id) {
        Supplier<V> provider = this.getSupplier(id);
        return provider == null ? null : (V)provider.get();
    }

    public int getSize() {
        return this.idToSupplier.size();
    }
}

