/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting;

import com.g4mesoft.setting.GSISettingDecoder;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.types.GSUnknownSetting;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import com.google.common.base.Predicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public final class GSSettingMap {
    public static final int MAX_TYPESTRING_LENGTH = 16;
    private final GSSettingCategory category;
    private final Map<String, GSSetting<?>> settings;
    private final GSSettingManager owner;

    public GSSettingMap(GSSettingCategory category, GSSettingManager owner) {
        this.category = category;
        this.owner = owner;
        this.settings = new LinkedHashMap();
    }

    public boolean isRegistered(String name) {
        return this.settings.containsKey(name);
    }

    public GSSetting<?> getSetting(String name) {
        return this.settings.get(name);
    }

    public void registerSetting(GSSetting<?> setting) {
        GSSetting<?> currentSetting = this.getSetting(setting.getName());
        if (currentSetting != null) {
            currentSetting.setSettingOwner(null);
            if (this.owner != null) {
                this.owner.settingRemoved(this.category, currentSetting);
            }
        }
        this.settings.put(setting.getName(), setting);
        setting.setSettingOwner(this);
        if (this.owner != null) {
            this.owner.settingAdded(this.category, setting);
        }
        if (currentSetting != null) {
            this.setValueFromLoadedSetting(setting, currentSetting);
        }
    }

    private void setValueFromLoadedSetting(GSSetting<?> setting, GSSetting<?> loadedSetting) {
        if (setting.isSameSetting(loadedSetting)) {
            setting.setIfSameType(loadedSetting);
        } else {
            setting.reset();
        }
    }

    public void clearSettings() {
        for (GSSetting<?> setting : this.settings.values()) {
            setting.setSettingOwner(null);
            if (this.owner == null) continue;
            this.owner.settingRemoved(this.category, setting);
        }
        this.settings.clear();
    }

    public GSSetting<?> removeSetting(String name) {
        GSSetting<?> currentSetting = this.settings.remove(name);
        if (currentSetting != null) {
            this.owner.settingRemoved(this.category, currentSetting);
        }
        return currentSetting;
    }

    public void resetSettings() {
        for (GSSetting<?> setting : this.settings.values()) {
            setting.reset();
        }
    }

    public boolean isDisjoint(GSSettingMap other) {
        for (String name : this.settings.keySet()) {
            if (!other.isRegistered(name)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public Collection<GSSetting<?>> getSettings() {
        return Collections.unmodifiableCollection(this.settings.values());
    }

    void settingChanged(GSSetting<?> setting) {
        if (this.owner != null) {
            this.owner.settingChanged(this.category, setting);
        }
    }

    public GSSettingCategory getCategory() {
        return this.category;
    }

    public void readSettings(GSDecodeBuffer buf) throws DecoderException {
        int remaining = buf.readInt();
        while (remaining-- > 0) {
            Object setting;
            String name = buf.readString();
            String type = buf.readString(16);
            int sizeInBytes = buf.readInt();
            if (!buf.isReadable(sizeInBytes)) {
                throw new DecoderException("Not enough bytes in buffer!");
            }
            int settingEnd = buf.getLocation() + sizeInBytes;
            GSISettingDecoder<String> decoder = GSSettingManager.getDecoder(type);
            if (decoder == null) {
                byte[] data = new byte[sizeInBytes];
                buf.readBytes(data);
                setting = new GSUnknownSetting(name, type, data);
            } else {
                setting = decoder.decodeSetting(name, buf);
                int off = settingEnd - buf.getLocation();
                if (off > 0) {
                    buf.skipBytes(off);
                } else {
                    buf.setLocation(settingEnd);
                }
            }
            GSSetting<?> currentSetting = this.getSetting(((GSSetting)setting).getName());
            if (currentSetting != null) {
                this.setValueFromLoadedSetting(currentSetting, (GSSetting<?>)setting);
                continue;
            }
            ((GSSetting)setting).setActive(false);
            ((GSSetting)setting).setSettingOwner(this);
            this.settings.put(((GSSetting)setting).getName(), (GSSetting<?>)setting);
            if (this.owner == null) continue;
            this.owner.settingAdded(this.category, (GSSetting<?>)setting);
        }
    }

    public void writeSettings(GSEncodeBuffer buf) throws DecoderException {
        this.writeSettings(buf, (Predicate<GSSetting<?>>)Predicates.alwaysTrue());
    }

    public void writeSettings(GSEncodeBuffer buf, Predicate<GSSetting<?>> settingFilter) throws DecoderException {
        ByteBuf settingBuffer = Unpooled.buffer();
        ArrayList settingsToWrite = new ArrayList(this.settings.size());
        for (GSSetting<Object> setting : this.settings.values()) {
            if (!settingFilter.test(setting)) continue;
            settingsToWrite.add(setting);
        }
        buf.writeInt(settingsToWrite.size());
        for (GSSetting<Object> setting : settingsToWrite) {
            buf.writeString(setting.getName());
            GSISettingDecoder<GSSetting<Object>> decoder = GSSettingManager.getDecoder(setting);
            if (decoder == null) {
                if (setting instanceof GSUnknownSetting) {
                    GSUnknownSetting unknSetting = (GSUnknownSetting)setting;
                    buf.writeString(unknSetting.getType(), 16);
                    buf.writeInt(unknSetting.getData().length);
                    buf.writeBytes(unknSetting.getData());
                    continue;
                }
                buf.writeString("UNKN");
                buf.writeInt(0);
                continue;
            }
            decoder.encodeSetting(GSEncodeBuffer.wrap(settingBuffer), setting);
            buf.writeString(decoder.getTypeString());
            buf.writeInt(settingBuffer.readableBytes());
            buf.writeBytes(settingBuffer);
            settingBuffer.clear();
        }
        settingsToWrite.clear();
        settingBuffer.release(settingBuffer.refCnt());
    }
}

