/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting.types;

import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.ui.util.GSMathUtil;

public class GSFloatSetting
extends GSSetting<Float> {
    private volatile float value;
    private final float minValue;
    private final float maxValue;
    private final float interval;

    public GSFloatSetting(String name, float defaultValue) {
        this(name, defaultValue, true);
    }

    public GSFloatSetting(String name, float defaultValue, boolean visibleInGui) {
        this(name, defaultValue, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, visibleInGui);
    }

    public GSFloatSetting(String name, float defaultValue, float minValue, float maxValue) {
        this(name, defaultValue, minValue, maxValue, true);
    }

    public GSFloatSetting(String name, float defaultValue, float minValue, float maxValue, boolean visibleInGui) {
        this(name, defaultValue, minValue, maxValue, 0.0f, visibleInGui);
    }

    public GSFloatSetting(String name, float defaultValue, float minValue, float maxValue, float interval) {
        this(name, defaultValue, minValue, maxValue, interval, true);
    }

    public GSFloatSetting(String name, float defaultValue, float minValue, float maxValue, float interval, boolean visibleInGui) {
        super(name, Float.valueOf(defaultValue), visibleInGui);
        if (Float.isNaN(interval) || interval <= 0.0f) {
            throw new IllegalArgumentException("interval must be positive");
        }
        if (Float.isNaN(minValue)) {
            throw new IllegalArgumentException("minValue is NaN");
        }
        if (Float.isNaN(maxValue)) {
            throw new IllegalArgumentException("maxValue is NaN");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must not be greater than maxValue");
        }
        if (Float.isNaN(defaultValue)) {
            throw new IllegalArgumentException("defaultValue is NaN");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.interval = interval;
        this.value = this.adjustValue(defaultValue);
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    public GSFloatSetting set(Float value) {
        return this.set(value.floatValue());
    }

    public GSFloatSetting set(float value) {
        float newValue = this.adjustValue(value);
        if (newValue != this.value) {
            this.value = newValue;
            this.notifyOwnerChange();
        }
        return this;
    }

    private float adjustValue(float value) {
        if (!GSMathUtil.equalsApproximate((float)(this.interval * 0.5f), (float)0.0f)) {
            float deviation = value % this.interval;
            value -= deviation;
            if (Math.abs(deviation) > this.interval * 0.5f) {
                value = deviation < 0.0f ? value - this.interval : value + this.interval;
            }
        }
        return GSMathUtil.clamp((float)value, (float)this.minValue, (float)this.maxValue);
    }

    public GSFloatSetting increment() {
        return this.increment(1);
    }

    public GSFloatSetting increment(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be positive!");
        }
        float newValue = this.value + this.interval * (float)count;
        if (newValue > this.maxValue) {
            newValue = this.minValue;
        }
        return this.set(newValue);
    }

    public GSFloatSetting decrement() {
        return this.decrement(1);
    }

    public GSFloatSetting decrement(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be positive!");
        }
        float newValue = this.value - this.interval * (float)count;
        if (newValue < this.minValue) {
            newValue = this.maxValue;
        }
        return this.set(newValue);
    }

    @Override
    public boolean isDefault() {
        return GSMathUtil.equalsApproximate((float)((Float)this.defaultValue).floatValue(), (float)this.value);
    }

    @Override
    public boolean isSameType(GSSetting<?> other) {
        return other instanceof GSFloatSetting;
    }

    @Override
    public boolean isSameSetting(GSSetting<?> other) {
        if (other instanceof GSFloatSetting) {
            GSFloatSetting floatSetting = (GSFloatSetting)other;
            if (!GSMathUtil.equalsApproximate((float)((Float)this.defaultValue).floatValue(), (float)((Float)floatSetting.getDefault()).floatValue())) {
                return false;
            }
            if (!GSMathUtil.equalsApproximate((float)this.minValue, (float)floatSetting.getMin())) {
                return false;
            }
            if (!GSMathUtil.equalsApproximate((float)this.maxValue, (float)floatSetting.getMax())) {
                return false;
            }
            return GSMathUtil.equalsApproximate((float)this.interval, (float)floatSetting.getInterval());
        }
        return false;
    }

    public float getMin() {
        return this.minValue;
    }

    public float getMax() {
        return this.maxValue;
    }

    public float getInterval() {
        return this.interval;
    }

    @Override
    public GSSetting<Float> copySetting() {
        return new GSFloatSetting(this.name, ((Float)this.defaultValue).floatValue(), this.minValue, this.maxValue, this.interval, this.visibleInGui).set(this.value).setEnabledInGui(this.isEnabledInGui());
    }
}

