/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting.types;

import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.ui.util.GSMathUtil;

public class GSIntegerSetting
extends GSSetting<Integer> {
    private volatile int value;
    private final int minValue;
    private final int maxValue;
    private final int interval;

    public GSIntegerSetting(String name, int defaultValue) {
        this(name, defaultValue, true);
    }

    public GSIntegerSetting(String name, int defaultValue, boolean visibleInGui) {
        this(name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, visibleInGui);
    }

    public GSIntegerSetting(String name, int defaultValue, int minValue, int maxValue) {
        this(name, defaultValue, minValue, maxValue, true);
    }

    public GSIntegerSetting(String name, int defaultValue, int minValue, int maxValue, boolean visibleInGui) {
        this(name, defaultValue, minValue, maxValue, 1, visibleInGui);
    }

    public GSIntegerSetting(String name, int defaultValue, int minValue, int maxValue, int interval) {
        this(name, defaultValue, minValue, maxValue, interval, true);
    }

    public GSIntegerSetting(String name, int defaultValue, int minValue, int maxValue, int interval, boolean visibleInGui) {
        super(name, defaultValue, visibleInGui);
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be positive");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must not be greater than maxValue");
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("defaultValue is not in range");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.interval = interval;
        this.value = this.adjustValue(defaultValue);
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Deprecated
    public Integer getValue() {
        return this.get();
    }

    public GSIntegerSetting set(Integer value) {
        return this.set((int)value);
    }

    @Deprecated
    public GSIntegerSetting setValue(Integer value) {
        return this.set(value);
    }

    public GSIntegerSetting set(int value) {
        int newValue = this.adjustValue(value);
        if (newValue != this.value) {
            this.value = newValue;
            this.notifyOwnerChange();
        }
        return this;
    }

    private int adjustValue(int value) {
        if (this.interval / 2 != 0) {
            int deviation = value % this.interval;
            value -= deviation;
            if (Math.abs(deviation) > this.interval / 2) {
                value = deviation < 0 ? value - this.interval : value + this.interval;
            }
        }
        return GSMathUtil.clamp((int)value, (int)this.minValue, (int)this.maxValue);
    }

    public GSIntegerSetting increment() {
        return this.increment(1);
    }

    public GSIntegerSetting increment(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be positive!");
        }
        long newValue = this.value + this.interval * count;
        if (newValue > (long)this.maxValue) {
            newValue = this.minValue;
        }
        return this.set((int)newValue);
    }

    public GSIntegerSetting decrement() {
        return this.decrement(1);
    }

    public GSIntegerSetting decrement(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be positive!");
        }
        long newValue = this.value - this.interval * count;
        if (newValue < (long)this.minValue) {
            newValue = this.maxValue;
        }
        return this.set((int)newValue);
    }

    @Override
    public boolean isDefault() {
        return (Integer)this.defaultValue == this.value;
    }

    @Override
    public boolean isSameType(GSSetting<?> other) {
        return other instanceof GSIntegerSetting;
    }

    @Override
    public boolean isSameSetting(GSSetting<?> other) {
        if (other instanceof GSIntegerSetting) {
            GSIntegerSetting integerSetting = (GSIntegerSetting)other;
            if (this.defaultValue != integerSetting.getDefault()) {
                return false;
            }
            if (this.minValue != integerSetting.getMin()) {
                return false;
            }
            if (this.maxValue != integerSetting.getMax()) {
                return false;
            }
            return this.interval == integerSetting.getInterval();
        }
        return false;
    }

    public int getMin() {
        return this.minValue;
    }

    public int getMax() {
        return this.maxValue;
    }

    @Deprecated
    public final int getMinValue() {
        return this.getMin();
    }

    @Deprecated
    public final int getMaxValue() {
        return this.getMax();
    }

    public int getInterval() {
        return this.interval;
    }

    @Override
    public GSSetting<Integer> copySetting() {
        return new GSIntegerSetting(this.name, (Integer)this.defaultValue, this.minValue, this.maxValue, this.interval, this.visibleInGui).set(this.value).setEnabledInGui(this.isEnabledInGui());
    }
}

