/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.setting.types;

import com.g4mesoft.setting.GSSetting;
import java.util.Objects;

public class GSStringSetting
extends GSSetting<String> {
    private volatile String value;

    public GSStringSetting(String name, String defaultValue) {
        super(name, defaultValue, true);
    }

    public GSStringSetting(String name, String defaultValue, boolean visibleInGui) {
        super(name, defaultValue, visibleInGui);
        if (defaultValue == null) {
            throw new IllegalArgumentException("GSStringSetting does not permit null values.");
        }
        this.value = defaultValue;
    }

    @Override
    public String get() {
        return this.value;
    }

    public GSStringSetting set(String value) {
        if (!value.equals(this.value)) {
            this.value = value;
            this.notifyOwnerChange();
        }
        return this;
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.defaultValue, this.value);
    }

    @Override
    public boolean isSameType(GSSetting<?> other) {
        return other instanceof GSStringSetting;
    }

    @Override
    public GSSetting<String> copySetting() {
        return new GSStringSetting(this.name, (String)this.defaultValue, this.visibleInGui).set(this.value).setEnabledInGui(this.isEnabledInGui());
    }
}

