/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.util;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4076;

public class GSDecodeBuffer
implements ReferenceCounted {
    private final ByteBuf buffer;

    private GSDecodeBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public void readBytes(byte[] dst) {
        this.readBytes(dst, dst.length);
    }

    public void readBytes(byte[] dst, int length) {
        this.readBytes(dst, 0, length);
    }

    public void readBytes(byte[] dst, int dstOffset, int length) {
        this.buffer.readBytes(dst, dstOffset, length);
    }

    public void readBytes(ByteBuf dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    private int readVarInt() {
        byte data;
        int value = 0;
        int count = 0;
        do {
            if (count >= 5) {
                throw new DecoderException("VarInt too big");
            }
            data = this.readByte();
            value |= (data & 0x7F) << 7 * count;
            ++count;
        } while ((data & 0x80) != 0);
        return value;
    }

    public byte[] readByteArray() {
        return this.readByteArray(null);
    }

    public byte[] readByteArray(byte[] dst) {
        int length = this.readVarInt();
        if (dst == null || length != dst.length) {
            dst = new byte[length];
        }
        this.readBytes(dst);
        return dst;
    }

    public short[] readShortArray() {
        return this.readShortArray(null);
    }

    public short[] readShortArray(short[] dst) {
        int length = this.readVarInt();
        if (dst == null || length != dst.length) {
            dst = new short[length];
        }
        for (int i = 0; i < length; ++i) {
            dst[i] = this.readShort();
        }
        return dst;
    }

    public int[] readIntArray() {
        return this.readIntArray(null);
    }

    public int[] readIntArray(int[] dst) {
        int length = this.readVarInt();
        if (dst == null || length != dst.length) {
            dst = new int[length];
        }
        for (int i = 0; i < length; ++i) {
            dst[i] = this.readInt();
        }
        return dst;
    }

    public long[] readLongArray() {
        return this.readLongArray(null);
    }

    public long[] readLongArray(long[] dst) {
        int length = this.readVarInt();
        if (dst == null || length != dst.length) {
            dst = new long[length];
        }
        for (int i = 0; i < length; ++i) {
            dst[i] = this.readLong();
        }
        return dst;
    }

    public String readString() {
        return this.readString(Short.MAX_VALUE);
    }

    public String readString(int lengthLimit) {
        return this.readString(CharsetUtil.UTF_8, lengthLimit);
    }

    public String readString(Charset charset) {
        return this.readString(charset, Short.MAX_VALUE);
    }

    public String readString(Charset charset, int encodedLimit) {
        int length = this.readVarInt();
        if (length > encodedLimit) {
            throw new DecoderException("encoded length exceeds limit");
        }
        String value = this.buffer.toString(this.getLocation(), length, charset);
        this.setLocation(this.getLocation() + length);
        return value;
    }

    public class_2960 readIdentifier() {
        return class_2960.method_60654((String)this.readString());
    }

    public UUID readUUID() {
        long mostSigBits = this.readLong();
        long leastSigBits = this.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public class_2338 readBlockPos() {
        long value = this.readLong();
        int x = (int)(value << 0 >> 38);
        int y = (int)(value << 52 >> 52);
        int z = (int)(value << 26 >> 38);
        return new class_2338(x, y, z);
    }

    public class_1923 readChunkPos() {
        int z = this.readInt();
        int x = this.readInt();
        return new class_1923(x, z);
    }

    public class_4076 readChunkSectionPos() {
        long value = this.readLong();
        int x = (int)(value << 0 >> 42);
        int y = (int)(value << 44 >> 44);
        int z = (int)(value << 22 >> 42);
        return class_4076.method_18676((int)x, (int)y, (int)z);
    }

    public boolean getBoolean(int location) {
        return this.buffer.getBoolean(location);
    }

    public byte getByte(int location) {
        return this.buffer.getByte(location);
    }

    public void getBytes(int location, byte[] dst) {
        this.getBytes(location, dst, dst.length);
    }

    public void getBytes(int location, byte[] dst, int length) {
        this.getBytes(location, dst, 0, length);
    }

    public void getBytes(int location, byte[] dst, int dstOffset, int length) {
        this.buffer.getBytes(location, dst, dstOffset, length);
    }

    public short getShort(int location) {
        return this.buffer.getShort(location);
    }

    public int getMedium(int location) {
        return this.buffer.getMedium(location);
    }

    public int getInt(int location) {
        return this.buffer.getInt(location);
    }

    public long getLong(int location) {
        return this.buffer.getLong(location);
    }

    public float getFloat(int location) {
        return this.buffer.getFloat(location);
    }

    public double getDouble(int location) {
        return this.buffer.getDouble(location);
    }

    public short getUnsignedByte(int location) {
        return this.buffer.getUnsignedByte(location);
    }

    public int getUnsignedShort(int location) {
        return this.buffer.getUnsignedShort(location);
    }

    public int getUnsignedMedium(int location) {
        return this.buffer.getUnsignedMedium(location);
    }

    public long getUnsignedInt(int location) {
        return this.buffer.getUnsignedInt(location);
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public boolean isReadable() {
        return this.buffer.isReadable();
    }

    public boolean isReadable(int size) {
        return this.buffer.isReadable(size);
    }

    public int getLocation() {
        return this.buffer.readerIndex();
    }

    public void setLocation(int location) {
        this.buffer.readerIndex(location);
    }

    public void markLocation() {
        this.buffer.markReaderIndex();
    }

    public void resetLocation() {
        this.buffer.resetReaderIndex();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public GSDecodeBuffer retain() {
        return new GSDecodeBuffer(this.buffer.retain());
    }

    public GSDecodeBuffer retain(int increment) {
        return new GSDecodeBuffer(this.buffer.retain(increment));
    }

    public GSDecodeBuffer touch() {
        this.buffer.touch();
        return this;
    }

    public GSDecodeBuffer touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    public boolean release() {
        return this.buffer.release();
    }

    public boolean release(int decrement) {
        return this.buffer.release(decrement);
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public static GSDecodeBuffer wrap(ByteBuf buffer) {
        return new GSDecodeBuffer(buffer);
    }
}

