/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.fruitforge.free.isleep.commands.LeaveCommand;
import com.fruitforge.free.isleep.commands.ReloadCommand;
import com.fruitforge.free.isleep.config.ConfigLoader;
import com.fruitforge.free.isleep.config.VersionLoader;
import com.fruitforge.free.isleep.internal.LogManager;
import com.fruitforge.free.isleep.listeners.BedListener;
import com.fruitforge.free.isleep.utils.SleepUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    public static final String CONFIG_VERSION = "1.0";
    public static final String PLUGIN_VERSION = "1.0-SNAPSHOT";
    private LogManager logManager;
    private ConfigLoader configLoader;
    private VersionLoader versionLoader;
    private SleepUtils sleepUtils;
    private ProtocolManager protocolManager;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        this.logManager = new LogManager(this);
        this.configLoader = new ConfigLoader(this, this.logManager, CONFIG_VERSION, PLUGIN_VERSION);
        this.versionLoader = new VersionLoader(this, this.configLoader, this.logManager, CONFIG_VERSION);
        this.versionLoader.checkVersion();
        if (this.getServer().getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.protocolManager = ProtocolLibrary.getProtocolManager();
        }
        this.sleepUtils = new SleepUtils(this, this.protocolManager);
        this.getServer().getPluginManager().registerEvents((Listener)new BedListener(this), (Plugin)this);
        this.getCommand("sleepreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("leave").setExecutor((CommandExecutor)new LeaveCommand(this));
        this.logManager.logSuccess("ISleep plugin enabled successfully in " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    public void onDisable() {
        this.logManager.logInfo("ISleep plugin disabled.");
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public ConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    public SleepUtils getSleepUtils() {
        return this.sleepUtils;
    }
}

