/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep.config;

import com.fruitforge.free.isleep.Main;
import com.fruitforge.free.isleep.internal.LogManager;
import com.fruitforge.free.isleep.lib.net.kyori.adventure.text.Component;
import com.fruitforge.free.isleep.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import com.fruitforge.free.isleep.lib.org.simpleyaml.configuration.file.YamlFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConfigLoader {
    private YamlFile settings;
    private File settingsFile;
    private final Main main;
    private final LogManager logManager;
    private final String configVersion;
    private final String pluginVersion;
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ConfigLoader(Main main, LogManager logManager, String configVersion, String pluginVersion) {
        this.main = main;
        this.logManager = logManager;
        this.configVersion = configVersion;
        this.pluginVersion = pluginVersion;
        this.loadConfig();
        this.mergeDefaults();
    }

    private void saveConfig() {
        try {
            this.settings.save(this.settingsFile);
            this.logManager.logSuccess("Configuration saved.");
        }
        catch (IOException e) {
            this.logManager.logError("Error saving configuration", e.getMessage());
        }
    }

    public void loadConfig() {
        this.settingsFile = new File(this.main.getDataFolder(), "Settings.yml");
        if (!this.settingsFile.exists()) {
            this.main.saveResource("Settings.yml", false);
            this.logManager.logSuccess("Created default Settings.yml.");
        }
        try {
            this.settings = YamlFile.loadConfiguration(this.settingsFile, true);
            this.logManager.logSuccess("Configuration loaded.");
        }
        catch (Exception e) {
            this.logManager.logError("Error loading configuration", e.getMessage());
            this.handleErrorConfig();
        }
    }

    private void handleErrorConfig() {
        File errorDir = new File(this.main.getDataFolder(), "Error");
        errorDir.mkdirs();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        File errorFile = new File(errorDir, "ErrorConfig_" + timestamp + ".yml");
        if (this.settingsFile.renameTo(errorFile)) {
            this.logManager.logSuccess("Backed up error config to " + errorFile.getName());
            this.main.saveResource("Settings.yml", false);
            this.loadConfig();
        } else {
            this.logManager.logError("Failed to backup error config", "");
        }
    }

    public void mergeDefaults() {
        YamlFile defaults = this.loadDefaultConfig();
        if (defaults == null) {
            return;
        }
        for (String key : defaults.getKeys(true)) {
            if (this.settings.contains(key)) continue;
            this.settings.set(key, defaults.get(key));
            this.logManager.logInfo("Added missing config key: " + key);
        }
        this.saveConfig();
    }

    private YamlFile loadDefaultConfig() {
        try {
            YamlFile defaults = new YamlFile();
            defaults.load(new InputStreamReader(this.main.getResource("Settings.yml")));
            return defaults;
        }
        catch (Exception e) {
            this.logManager.logError("Error loading default config", e.getMessage());
            return null;
        }
    }

    public void migrateConfig() {
        try {
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            File oldDir = new File(this.main.getDataFolder(), "OldConfig");
            oldDir.mkdirs();
            File backup = new File(oldDir, "OldConfig_" + timestamp + ".yml");
            Files.copy(this.settingsFile.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.logManager.logSuccess("Backed up old config to " + backup.getName());
            YamlFile oldConfig = YamlFile.loadConfiguration(backup, false);
            File tempDefault = new File(this.main.getDataFolder(), "temp_Settings.yml");
            Files.copy(this.main.getResource("Settings.yml"), tempDefault.toPath(), StandardCopyOption.REPLACE_EXISTING);
            YamlFile newDefaults = YamlFile.loadConfiguration(tempDefault, true);
            for (String key : oldConfig.getKeys(true)) {
                if (!newDefaults.contains(key)) continue;
                newDefaults.set(key, oldConfig.get(key));
                this.logManager.logInfo("Migrated key: " + key);
            }
            this.settings = newDefaults;
            this.settings.set("Config-Version", this.configVersion);
            this.settings.set("Plugin-Version", this.pluginVersion);
            this.saveConfig();
            tempDefault.delete();
            this.logManager.logSuccess("Config migrated successfully.");
        }
        catch (IOException e) {
            this.logManager.logError("Error migrating config", e.getMessage());
        }
    }

    public String getConfigVersion() {
        return this.settings.getString("Config-Version");
    }

    public Component getPrefixedMessage(String path) {
        String prefix = this.settings.getString("Messages.Prefix", "");
        String message = this.settings.getString("Messages." + path, "<red>Missing message: " + path + "</red>");
        return miniMessage.deserialize(prefix + message);
    }

    public Component getMessage(String path) {
        String message = this.settings.getString("Messages." + path, "<red>Missing message: " + path + "</red>");
        return miniMessage.deserialize(message);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.settings.getBoolean(path, def);
    }

    public String getString(String path, String def) {
        return this.settings.getString(path, def);
    }
}

