/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep.config;

import com.fruitforge.free.isleep.Main;
import com.fruitforge.free.isleep.config.ConfigLoader;
import com.fruitforge.free.isleep.internal.LogManager;

public class VersionLoader {
    private final Main main;
    private final ConfigLoader configLoader;
    private final LogManager logManager;
    private final String expectedVersion;

    public VersionLoader(Main main, ConfigLoader configLoader, LogManager logManager, String expectedVersion) {
        this.main = main;
        this.configLoader = configLoader;
        this.logManager = logManager;
        this.expectedVersion = expectedVersion;
    }

    public void checkVersion() {
        String currentVersion = this.configLoader.getConfigVersion();
        if (!currentVersion.equals(this.expectedVersion)) {
            this.logManager.logWarning("Outdated config version detected: " + currentVersion + " (expected: " + this.expectedVersion + ")");
            this.logManager.logInfo("Starting config migration...");
            this.configLoader.migrateConfig();
        } else {
            this.logManager.logInfo("Config version is current: " + currentVersion);
        }
    }
}

