/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep.lib.org.simpleyaml.configuration.comments.format;

import com.fruitforge.free.isleep.lib.org.simpleyaml.configuration.comments.format.BlankLineYamlCommentFormatter;
import com.fruitforge.free.isleep.lib.org.simpleyaml.configuration.comments.format.PrettyYamlCommentFormatter;
import com.fruitforge.free.isleep.lib.org.simpleyaml.configuration.comments.format.YamlCommentFormatter;

public enum YamlCommentFormat {
    DEFAULT(YamlCommentFormatter::new),
    PRETTY(PrettyYamlCommentFormatter::new),
    BLANK_LINE(BlankLineYamlCommentFormatter::new),
    RAW(() -> new YamlCommentFormatter().stripPrefix(false).trim(false));

    private YamlCommentFormatter yamlCommentFormatter;
    private final YamlCommentFormatterFactory yamlCommentFormatterFactory;

    private YamlCommentFormat(YamlCommentFormatterFactory yamlCommentFormatterFactory) {
        this.yamlCommentFormatterFactory = yamlCommentFormatterFactory;
    }

    public YamlCommentFormatter commentFormatter() {
        if (this.yamlCommentFormatter == null) {
            this.buildCommentFormatter();
        }
        return this.yamlCommentFormatter;
    }

    private void buildCommentFormatter() {
        this.yamlCommentFormatter = this.yamlCommentFormatterFactory.commentFormatter();
    }

    public static void reset() {
        for (YamlCommentFormat format : YamlCommentFormat.values()) {
            if (format.yamlCommentFormatter == null) continue;
            format.buildCommentFormatter();
        }
    }

    @FunctionalInterface
    public static interface YamlCommentFormatterFactory {
        public YamlCommentFormatter commentFormatter();
    }
}

