/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep.listeners;

import com.fruitforge.free.isleep.Main;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class BedListener
implements Listener {
    private final Main main;

    public BedListener(Main main) {
        this.main = main;
    }

    private boolean isVersionAtLeast(int requiredMajor, int requiredMinor) {
        String[] versionParts = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        int serverMajor = Integer.parseInt(versionParts[0]);
        int serverMinor = Integer.parseInt(versionParts[1]);
        return serverMajor > requiredMajor || serverMajor == requiredMajor && serverMinor >= requiredMinor;
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        if (this.main.getConfigLoader().getBoolean("SneakOnly", false) && !player.isSneaking()) {
            this.main.getSleepUtils().sendPrefixedMessage((CommandSender)player, "NotSneaking");
            event.setUseBed(Event.Result.DENY);
            return;
        }
        boolean allow = false;
        String denyMessage = null;
        switch (event.getBedEnterResult()) {
            case NOT_POSSIBLE_HERE: {
                if (this.main.getConfigLoader().getBoolean("IgnoreWhere", true)) {
                    allow = true;
                    break;
                }
                denyMessage = "NotPossibleHere";
                break;
            }
            case NOT_POSSIBLE_NOW: {
                if (this.main.getConfigLoader().getBoolean("IgnoreTime", true)) {
                    allow = true;
                    break;
                }
                denyMessage = "NotPossibleNow";
                break;
            }
            case TOO_FAR_AWAY: {
                if (this.main.getConfigLoader().getBoolean("IgnoreDistance", true)) {
                    allow = true;
                    break;
                }
                denyMessage = "TooFarAway";
                break;
            }
            case NOT_SAFE: {
                if (this.main.getConfigLoader().getBoolean("IgnoreSafety", true)) {
                    allow = true;
                    break;
                }
                denyMessage = "NotSafe";
                break;
            }
            case OTHER_PROBLEM: {
                if (this.main.getConfigLoader().getBoolean("IgnoreOthers", true)) {
                    allow = true;
                    break;
                }
                denyMessage = "OtherProblem";
                break;
            }
            case OK: {
                allow = true;
                break;
            }
        }
        if (!allow) {
            if (denyMessage != null) {
                this.main.getSleepUtils().sendPrefixedMessage((CommandSender)player, denyMessage);
            }
            event.setUseBed(Event.Result.DENY);
            return;
        }
        World.Environment env = player.getWorld().getEnvironment();
        if (!this.main.getConfigLoader().getBoolean("IgnoreTime", true) && env == World.Environment.NORMAL) {
            long time = player.getWorld().getTime();
            boolean isNight = time >= 12541L && time <= 23458L;
            boolean isThundering = player.getWorld().isThundering();
            if (!isNight && !isThundering) {
                allow = false;
                denyMessage = "NotPossibleNow";
            }
        }
        if (!this.main.getConfigLoader().getBoolean("IgnoreSafety", true)) {
            boolean hasHostile;
            HashSet<String> hostileTypeNames = new HashSet<String>();
            hostileTypeNames.add("BLAZE");
            hostileTypeNames.add("CAVE_SPIDER");
            hostileTypeNames.add("CREEPER");
            hostileTypeNames.add("DROWNED");
            hostileTypeNames.add("ELDER_GUARDIAN");
            hostileTypeNames.add("ENDERMAN");
            hostileTypeNames.add("ENDERMITE");
            hostileTypeNames.add("EVOKER");
            hostileTypeNames.add("GHAST");
            hostileTypeNames.add("GUARDIAN");
            hostileTypeNames.add("HUSK");
            hostileTypeNames.add("MAGMA_CUBE");
            hostileTypeNames.add("PHANTOM");
            hostileTypeNames.add("SHULKER");
            hostileTypeNames.add("SILVERFISH");
            hostileTypeNames.add("SKELETON");
            hostileTypeNames.add("SPIDER");
            hostileTypeNames.add("STRAY");
            hostileTypeNames.add("VEX");
            hostileTypeNames.add("VINDICATOR");
            hostileTypeNames.add("WITCH");
            hostileTypeNames.add("WITHER_SKELETON");
            hostileTypeNames.add("ZOMBIE");
            hostileTypeNames.add("ZOMBIE_VILLAGER");
            if (this.isVersionAtLeast(1, 14)) {
                hostileTypeNames.add("PILLAGER");
                hostileTypeNames.add("RAVAGER");
            }
            if (this.isVersionAtLeast(1, 16)) {
                hostileTypeNames.add("HOGLIN");
                hostileTypeNames.add("PIGLIN");
                hostileTypeNames.add("PIGLIN_BRUTE");
                hostileTypeNames.add("ZOGLIN");
            }
            if (this.isVersionAtLeast(1, 18)) {
                hostileTypeNames.add("WARDEN");
            }
            if (this.isVersionAtLeast(1, 21)) {
                hostileTypeNames.add("BOGGED");
                hostileTypeNames.add("BREEZE");
            }
            if (hasHostile = player.getNearbyEntities(8.0, 5.0, 8.0).stream().anyMatch(entity -> hostileTypeNames.contains(entity.getType().name()))) {
                allow = false;
                denyMessage = "NotSafe";
            }
        }
        if (!this.main.getConfigLoader().getBoolean("IgnoreDistance", true)) {
            Block bed = event.getBed();
            double distance = player.getLocation().distanceSquared(bed.getLocation());
            if (distance > 36.0) {
                allow = false;
                denyMessage = "TooFarAway";
            }
        }
        if (!allow) {
            boolean shouldExplode;
            boolean isNetherOrEnd = env == World.Environment.NETHER || env == World.Environment.THE_END;
            boolean explodeOnUnsafe = this.main.getConfigLoader().getBoolean("ExplodeOnUnsafe", false);
            boolean bl = shouldExplode = isNetherOrEnd && explodeOnUnsafe && "NotSafe".equals(denyMessage);
            if (denyMessage != null) {
                this.main.getSleepUtils().sendPrefixedMessage((CommandSender)player, denyMessage);
            }
            if (shouldExplode) {
                event.setUseBed(Event.Result.DENY);
                Block bed = event.getBed();
                bed.getWorld().createExplosion(bed.getLocation(), 5.0f, false, true);
            } else if (isNetherOrEnd && "NotSafe".equals(denyMessage)) {
                Location oldSpawn = player.getBedSpawnLocation();
                event.setUseBed(Event.Result.ALLOW);
                Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                    if (player.isSleeping()) {
                        player.teleport(player.getLocation().add(0.0, 0.1, 0.0));
                    }
                    player.setBedSpawnLocation(oldSpawn, true);
                }, 1L);
            } else {
                event.setUseBed(Event.Result.DENY);
            }
            return;
        }
        if (env != World.Environment.NORMAL) {
            boolean setSpawn = this.main.getConfigLoader().getBoolean("SetSpawnInOtherDimensions", true);
            Location oldSpawn = player.getBedSpawnLocation();
            event.setUseBed(Event.Result.ALLOW);
            if (setSpawn) {
                this.main.getSleepUtils().sendPrefixedMessage((CommandSender)player, "SpawnSet");
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                    if (player.isSleeping()) {
                        player.teleport(player.getLocation().add(0.0, 0.1, 0.0));
                    }
                    player.setBedSpawnLocation(oldSpawn, true);
                }, 60L);
            }
        } else {
            event.setUseBed(Event.Result.ALLOW);
        }
    }

    @EventHandler
    public void onBedInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !block.getType().name().endsWith("_BED")) {
            return;
        }
    }
}

