/*
 * Decompiled with CFR 0.152.
 */
package com.fruitforge.free.isleep.utils;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.fruitforge.free.isleep.Main;
import com.fruitforge.free.isleep.lib.net.kyori.adventure.text.Component;
import com.fruitforge.free.isleep.lib.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SleepUtils {
    private final Main main;
    private final ProtocolManager protocolManager;

    public SleepUtils(Main main, ProtocolManager protocolManager) {
        this.main = main;
        this.protocolManager = protocolManager;
    }

    public void sendPrefixedMessage(CommandSender sender, String path) {
        Component message = this.main.getConfigLoader().getPrefixedMessage(path);
        sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
    }

    public void sendMessage(CommandSender sender, String path) {
        Component message = this.main.getConfigLoader().getMessage(path);
        sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
    }

    public void forceExitSleep(Player player) {
        if (player.isSleeping()) {
            player.wakeup(false);
        }
    }

    public void showSleepAnimation(Player player, Block block) {
        if (this.protocolManager == null) {
            return;
        }
        String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
        String[] parts = version.split("\\.");
        int minor = Integer.parseInt(parts[1]);
        if (minor < 14) {
            PacketContainer bed = this.protocolManager.createPacket(PacketType.Play.Server.BED);
            bed.getIntegers().write(0, (Object)player.getEntityId());
            bed.getBlockPositionModifier().write(0, (Object)new BlockPosition(block.getX(), block.getY(), block.getZ()));
            this.protocolManager.broadcastServerPacket(bed);
        } else {
            PacketContainer metadata = this.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
            metadata.getIntegers().write(0, (Object)player.getEntityId());
            WrappedDataWatcher.Serializer poseSerializer = WrappedDataWatcher.Registry.get((Class)EnumWrappers.getEntityPoseClass());
            WrappedDataValue poseValue = new WrappedDataValue(6, poseSerializer, EnumWrappers.EntityPose.SLEEPING.toNms());
            metadata.getDataValueCollectionModifier().write(0, Collections.singletonList(poseValue));
            this.protocolManager.broadcastServerPacket(metadata);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> this.showWakeUpAnimation(player), 20L);
    }

    private void showWakeUpAnimation(Player player) {
        if (this.protocolManager == null) {
            return;
        }
        String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
        String[] parts = version.split("\\.");
        int minor = Integer.parseInt(parts[1]);
        if (minor < 14) {
            PacketContainer animation = this.protocolManager.createPacket(PacketType.Play.Server.ANIMATION);
            animation.getIntegers().write(0, (Object)player.getEntityId());
            animation.getIntegers().write(1, (Object)2);
            this.protocolManager.broadcastServerPacket(animation);
        } else {
            PacketContainer metadata = this.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
            metadata.getIntegers().write(0, (Object)player.getEntityId());
            WrappedDataWatcher.Serializer poseSerializer = WrappedDataWatcher.Registry.get((Class)EnumWrappers.getEntityPoseClass());
            WrappedDataValue poseValue = new WrappedDataValue(6, poseSerializer, EnumWrappers.EntityPose.STANDING.toNms());
            metadata.getDataValueCollectionModifier().write(0, Collections.singletonList(poseValue));
            this.protocolManager.broadcastServerPacket(metadata);
        }
    }
}

