package net.mt1006.mocap.api.v1.controller;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapActiveRecording;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface MocapController
{
	CommandInfo getCommandInfo();

	CommandInfo getCommandInfoForLevel(ServerLevel level);

	@Nullable MocapPlaybackRoot findPlayback(String id);

	List<? extends MocapPlaybackRoot> getActivePlaybacks();

	@Nullable MocapActiveRecording startRecording(ServerPlayer player);

	@Nullable MocapActiveRecording startRecording(ServerPlayer player, MocapRecordingConfig config, boolean startInstantly);

	@Nullable String getSetting(String name);

	boolean setSetting(String name, String val);

	boolean resetSetting(String name);
}
