package net.mt1006.mocap.utils;

import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelFutureListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.*;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.stats.Stat;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.portal.TeleportTransition;
import net.mt1006.mocap.mocap.playing.playback.RecordingPlayback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

// FakePlayer class from Forge
public class FakePlayer extends ServerPlayer
{
	private static final ClientInformation DEFAULT_CLIENT_INFO = ClientInformation.createDefault();
	public RecordingPlayback playback;
	private final boolean isInvulnerable;
	private int dyingTicks = -1;
	private boolean killedByPlayback = false;

	public FakePlayer(ServerLevel level, GameProfile profile, boolean isInvulnerable)
	{
		super(level.getServer(), level, profile, DEFAULT_CLIENT_INFO);
		this.connection = new FakePlayerNetHandler(level.getServer(), this, profile);
		this.isInvulnerable = isInvulnerable;

		this.invulnerableTime = 0;
	}

	@Override public void tick()
	{
		if (!isInvulnerable && invulnerableTime > 0) { invulnerableTime--; }

		if (dyingTicks >= 0)
		{
			dyingTicks--;
			if (dyingTicks == 0) { playback.stop(); }
		}
	}

	@Override public ServerPlayer teleport(@NotNull TeleportTransition dimensionTransition) { return null; }
	@Override public void displayClientMessage(@NotNull Component chatComponent, boolean actionBar) { }
	@Override public void awardStat(@NotNull Stat stat, int amount) { }

	@Override public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount)
	{
		return (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !isInvulnerable) && super.hurtServer(level, damageSource, amount);
	}

	@Override public void die(@NotNull DamageSource source)
	{
		if (!killedByPlayback) { dyingTicks = 20; }
	}

	@Override public boolean hasClientLoaded()
	{
		// it's necessary for damage playback to work with invulnerability enabled
		// also when killed by playback it's required for animation to be shown
		return true;
	}
	
	public void fakeKill()
	{
		killedByPlayback = true;
		kill(level());
	}

	public void fakeRespawn()
	{
		unsetRemoved();
		killedByPlayback = false;
	}

	private static class FakePlayerNetHandler extends ServerGamePacketListenerImpl
	{
		private static final net.minecraft.network.Connection DUMMY_CONNECTION = new DummyConnection(PacketFlow.CLIENTBOUND);

		public FakePlayerNetHandler(MinecraftServer server, ServerPlayer player, GameProfile profile)
		{
			//super(server, DUMMY_CONNECTION, player, new CommonListenerCookie(profile, 0, DEFAULT_CLIENT_INFO));
			super(server, DUMMY_CONNECTION, player, new CommonListenerCookie(profile, 0, DEFAULT_CLIENT_INFO, false));
		}

		@Override public void tick() { }
		@Override public void resetPosition() { }
		@Override public void disconnect(Component message) { }
		@Override public void handlePlayerInput(ServerboundPlayerInputPacket packet) { }
		@Override public void handleMoveVehicle(ServerboundMoveVehiclePacket packet) { }
		@Override public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packet) { }
		@Override public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket packet) { }
		@Override public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket packet) { }
		@Override public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket packet) { }
		@Override public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket packet) { }
		@Override public void handleSetCommandBlock(ServerboundSetCommandBlockPacket packet) { }
		@Override public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket packet) { }
		@Override public void handleRenameItem(ServerboundRenameItemPacket packet) { }
		@Override public void handleSetBeaconPacket(ServerboundSetBeaconPacket packet) { }
		@Override public void handleSetStructureBlock(ServerboundSetStructureBlockPacket packet) { }
		@Override public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket packet) { }
		@Override public void handleJigsawGenerate(ServerboundJigsawGeneratePacket packet) { }
		@Override public void handleSelectTrade(ServerboundSelectTradePacket packet) { }
		@Override public void handleEditBook(ServerboundEditBookPacket packet) { }
		@Override public void handleEntityTagQuery(ServerboundEntityTagQueryPacket packet) { }
		@Override public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket packet) { }
		@Override public void handleMovePlayer(ServerboundMovePlayerPacket packet) { }
		@Override public void teleport(double x, double y, double z, float yaw, float pitch) { }
		@Override public void handlePlayerAction(ServerboundPlayerActionPacket packet) { }
		@Override public void handleUseItemOn(ServerboundUseItemOnPacket packet) { }
		@Override public void handleUseItem(ServerboundUseItemPacket packet) { }
		@Override public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket packet) { }
		@Override public void handlePaddleBoat(ServerboundPaddleBoatPacket packet) { }
		@Override public void send(Packet<?> packet) { }
		@Override public void send(Packet<?> packet, @Nullable ChannelFutureListener sendListener) { }
		@Override public void handleSetCarriedItem(ServerboundSetCarriedItemPacket packet) { }
		@Override public void handleChat(ServerboundChatPacket packet) { }
		@Override public void handleAnimate(ServerboundSwingPacket packet) { }
		@Override public void handlePlayerCommand(ServerboundPlayerCommandPacket packet) { }
		@Override public void handleInteract(ServerboundInteractPacket packet) { }
		@Override public void handleClientCommand(ServerboundClientCommandPacket packet) { }
		@Override public void handleContainerClose(ServerboundContainerClosePacket packet) { }
		@Override public void handleContainerClick(ServerboundContainerClickPacket packet) { }
		@Override public void handlePlaceRecipe(ServerboundPlaceRecipePacket packet) { }
		@Override public void handleContainerButtonClick(ServerboundContainerButtonClickPacket packet) { }
		@Override public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket packet) { }
		@Override public void handleSignUpdate(ServerboundSignUpdatePacket packet) { }
		@Override public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket packet) { }
		@Override public void handleChangeDifficulty(ServerboundChangeDifficultyPacket packet) { }
		@Override public void handleLockDifficulty(ServerboundLockDifficultyPacket packet) { }
		@Override public void ackBlockChangesUpTo(int sequence) { }
		@Override public void handleChatCommand(ServerboundChatCommandPacket packet) { }
		@Override public void handleChatAck(ServerboundChatAckPacket packet) { }
		@Override public void sendPlayerChatMessage(PlayerChatMessage message, ChatType.Bound boundChatType) { }
		@Override public void sendDisguisedChatMessage(Component content, ChatType.Bound boundChatType) { }
		@Override public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket packet) { }
	}

	private static class DummyConnection extends net.minecraft.network.Connection
	{
		public DummyConnection(PacketFlow packetFlow)
		{
			super(packetFlow);
		}
	}
}
