/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.api.v1.modifiers;

import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;

public class MocapEntityFilterBuilder {
    private final StringBuilder builder = new StringBuilder();

    public MocapEntityFilterBuilder includeEntity(ResourceLocation id) {
        this.builder.append(id.toString());
        return this;
    }

    public MocapEntityFilterBuilder excludeEntity(ResourceLocation id) {
        this.builder.append("-");
        return this.includeEntity(id);
    }

    public MocapEntityFilterBuilder includeEntity(EntityType<?> entityType) {
        return this.includeEntity(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
    }

    public MocapEntityFilterBuilder excludeEntity(EntityType<?> entityType) {
        return this.excludeEntity(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
    }

    public MocapEntityFilterBuilder includeAll() {
        this.builder.append("*");
        return this;
    }

    public MocapEntityFilterBuilder excludeAll() {
        this.builder.append("-*");
        return this;
    }

    public MocapEntityFilterBuilder includeNamespace(String namespace) {
        if (!ResourceLocation.isValidNamespace((String)namespace)) {
            throw new ResourceLocationException("Invalid namespace!");
        }
        this.builder.append(namespace);
        this.builder.append(":*");
        return this;
    }

    public MocapEntityFilterBuilder excludeNamespace(String namespace) {
        this.builder.append("-");
        return this.includeNamespace(namespace);
    }

    public MocapEntityFilterBuilder includeTag(String tag) {
        this.builder.append("$");
        this.builder.append(tag);
        return this;
    }

    public MocapEntityFilterBuilder excludeTag(String tag) {
        this.builder.append("-");
        return this.includeTag(tag);
    }

    public MocapEntityFilterBuilder includeGroup(Group group) {
        this.builder.append("@");
        this.builder.append(group.name());
        this.builder.append(";");
        return this;
    }

    public MocapEntityFilterBuilder excludeGroup(Group group) {
        this.builder.append("-");
        return this.includeGroup(group);
    }

    public MocapEntityFilterBuilder appendFilter(String filter) {
        this.builder.append(filter);
        return this;
    }

    public MocapEntityFilter build() {
        if (this.builder.isEmpty()) {
            this.includeGroup(Group.NONE);
        }
        return EntityFilter.fromString(this.builder.toString());
    }

    public static enum Group {
        NONE,
        VEHICLES,
        PROJECTILES,
        ITEMS,
        MOBS,
        MINECARTS;

    }
}

