/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.io.FullCommandInfo;
import org.jetbrains.annotations.Nullable;

public class CommandUtils {
    public static ArgumentBuilder<CommandSourceStack, ?> playerNameArgument(Command<CommandSourceStack> command) {
        return Commands.argument((String)"player_name", (ArgumentType)StringArgumentType.string()).executes(command);
    }

    public static ArgumentBuilder<CommandSourceStack, ?> playerArguments(CommandBuildContext buildContext, Command<CommandSourceStack> command) {
        return CommandUtils.withModelArguments(buildContext, CommandUtils.playerNameArgument(command), command, true);
    }

    public static ArgumentBuilder<CommandSourceStack, ?> withModelArguments(CommandBuildContext buildContext, ArgumentBuilder<CommandSourceStack, ?> builder, Command<CommandSourceStack> command, boolean addPlayerAsEntity) {
        builder.then(Commands.literal((String)"skin_from_player").then(Commands.argument((String)"skin_player_name", (ArgumentType)StringArgumentType.greedyString()).executes(command)));
        builder.then(Commands.literal((String)"skin_from_file").then(Commands.argument((String)"skin_filename", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandSuggestions::skinFile).executes(command)));
        builder.then(Commands.literal((String)"skin_from_mineskin").then(Commands.argument((String)"mineskin_url", (ArgumentType)StringArgumentType.greedyString()).executes(command)));
        if (addPlayerAsEntity) {
            builder.then(Commands.literal((String)"player_as_entity").then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).executes(command)).then(Commands.argument((String)"nbt", (ArgumentType)NbtTagArgument.nbtTag()).executes(command))));
        }
        return builder;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> withModifiers(CommandBuildContext buildContext, ArgumentBuilder<CommandSourceStack, ?> builder, Command<CommandSourceStack> command, boolean isScene) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").then(Commands.literal((String)"start_delay").then(Commands.argument((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(Commands.literal((String)"wait_on_start").then(Commands.argument((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(Commands.literal((String)"wait_on_end").then(Commands.argument((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(Commands.literal((String)"wait_for_parent_end").then(Commands.argument((String)"wait_for_parent_end", (ArgumentType)BoolArgumentType.bool()).executes(command)))).then(Commands.literal((String)"loop").then(Commands.argument((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(command))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"transformations").then(Commands.literal((String)"rotation").then(Commands.argument((String)"deg", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mirror").then(Commands.literal((String)"none").executes(command))).then(Commands.literal((String)"x").executes(command))).then(Commands.literal((String)"z").executes(command))).then(Commands.literal((String)"xz").executes(command)))).then(((LiteralArgumentBuilder)Commands.literal((String)"scale").then(Commands.literal((String)"of_player").then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(Commands.literal((String)"of_scene").then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command))))).then(Commands.literal((String)"offset").then(Commands.argument((String)"offset_x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"offset_y", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"offset_z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").then(Commands.literal((String)"round_block_pos").then(Commands.argument((String)"round", (ArgumentType)BoolArgumentType.bool()).executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recording_center").then(Commands.literal((String)"auto").executes(command))).then(Commands.literal((String)"block_center").executes(command))).then(Commands.literal((String)"block_corner").executes(command))).then(Commands.literal((String)"actual").executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"scene_center").then(Commands.literal((String)"common_first").executes(command))).then(Commands.literal((String)"common_last").executes(command))).then(Commands.literal((String)"common_specific").then(Commands.argument((String)"specific_scene_element", (ArgumentType)StringArgumentType.string()).executes(command)))).then(Commands.literal((String)"individual").executes(command)))).then(Commands.literal((String)"center_offset").then(Commands.argument((String)"offset_x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"offset_y", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"offset_z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player_name").then(Commands.literal((String)"inherited").executes(command))).then(Commands.literal((String)"blank").executes(command))).then(Commands.literal((String)"set").then(CommandUtils.playerNameArgument(command))));
        builder.then(CommandUtils.withModelArguments(buildContext, Commands.literal((String)"player_skin"), command, false));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"player_as_entity").then(Commands.literal((String)"disabled").executes(command))).then(Commands.literal((String)"enabled").then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).executes(command)).then(Commands.argument((String)"nbt", (ArgumentType)NbtTagArgument.nbtTag()).executes(command)))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"entity_filter").then(Commands.literal((String)"disabled").executes(command))).then(Commands.literal((String)"enabled").then(Commands.argument((String)"entity_filter", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandSuggestions::entityFilter).executes(command))));
        if (isScene) {
            builder.then(Commands.literal((String)"subscene_name").then(Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(command)));
        }
        return builder;
    }

    public static Command<CommandSourceStack> command(Function<FullCommandInfo, Boolean> function) {
        return ctx -> (Boolean)function.apply(new FullCommandInfo((CommandContext<CommandSourceStack>)ctx)) != false ? 1 : 0;
    }

    public static RequiredArgumentBuilder<CommandSourceStack, String> withStringArgument(BiFunction<FullCommandInfo, String, Boolean> function, String arg) {
        return (RequiredArgumentBuilder)Commands.argument((String)arg, (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandUtils.stringCommand(function, (CommandContext<CommandSourceStack>)ctx, arg, false));
    }

    public static RequiredArgumentBuilder<CommandSourceStack, String> withInputArgument(BiFunction<FullCommandInfo, String, Boolean> function, SuggestionProvider<CommandSourceStack> suggestions, String arg) {
        return CommandUtils.withStringArgument(function, arg).suggests(suggestions);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, String> withInputAndStringArgument(TriFunction<FullCommandInfo, String, String, Boolean> function, SuggestionProvider<CommandSourceStack> suggestions, String arg1, String arg2) {
        return (RequiredArgumentBuilder)Commands.argument((String)arg1, (ArgumentType)StringArgumentType.string()).suggests(suggestions).then(Commands.argument((String)arg2, (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandUtils.twoStringCommand(function, (CommandContext<CommandSourceStack>)ctx, arg1, arg2)));
    }

    public static RequiredArgumentBuilder<CommandSourceStack, String> withTwoInputArguments(TriFunction<FullCommandInfo, String, String, Boolean> function, SuggestionProvider<CommandSourceStack> suggestions1, SuggestionProvider<CommandSourceStack> suggestions2, String arg1, String arg2) {
        return (RequiredArgumentBuilder)Commands.argument((String)arg1, (ArgumentType)StringArgumentType.string()).suggests(suggestions1).then(Commands.argument((String)arg2, (ArgumentType)StringArgumentType.string()).suggests(suggestions2).executes(ctx -> CommandUtils.twoStringCommand(function, (CommandContext<CommandSourceStack>)ctx, arg1, arg2)));
    }

    private static int stringCommand(BiFunction<FullCommandInfo, String, Boolean> function, CommandContext<CommandSourceStack> ctx, String arg, boolean nullable) {
        FullCommandInfo info = new FullCommandInfo(ctx);
        try {
            String str = info.getString(arg);
            return function.apply(info, str) != false ? 1 : 0;
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return function.apply(info, null) != false ? 1 : 0;
            }
            info.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return 0;
        }
    }

    private static int twoStringCommand(TriFunction<FullCommandInfo, String, String, Boolean> function, CommandContext<CommandSourceStack> ctx, String arg1, String arg2) {
        FullCommandInfo info = new FullCommandInfo(ctx);
        try {
            String str1 = info.getString(arg1);
            String str2 = info.getString(arg2);
            return function.apply(info, str1, str2) != false ? 1 : 0;
        }
        catch (IllegalArgumentException e) {
            info.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return 0;
        }
    }

    public static Pair<String, @Nullable String> splitIdStr(String str) {
        int dashPos = str.indexOf(45);
        int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
        String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
        return Pair.of((Object)Integer.toString(pos), (Object)expectedName);
    }

    public static Pair<Integer, @Nullable String> splitPosStr(String str) {
        int dashPos = str.indexOf(45);
        int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
        String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
        return Pair.of((Object)pos, (Object)expectedName);
    }

    @Nullable
    public static String getNode(List<? extends ParsedCommandNode<?>> nodes, int pos) {
        int size = nodes.size();
        if (pos < 0) {
            pos += size;
        }
        if (pos >= size || pos < 0) {
            return null;
        }
        return nodes.get(pos).getNode().getName();
    }

    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

