/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapTime;
import net.mt1006.mocap.api.v1.modifiers.MocapTimeModifiers;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playable.SceneFile;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import net.mt1006.mocap.utils.Utils;

public class ScenesCommand {
    private static final Command<CommandSourceStack> COMMAND_ADD_TO = CommandUtils.command(ScenesCommand::addTo);

    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder(CommandBuildContext buildContext) {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"scenes");
        commandBuilder.then(Commands.literal((String)"add").then(CommandUtils.withStringArgument(SceneFiles::add, "name")));
        commandBuilder.then(Commands.literal((String)"copy").then(CommandUtils.withInputAndStringArgument(ScenesCommand::copy, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "src_name", "dest_name")));
        commandBuilder.then(Commands.literal((String)"rename").then(CommandUtils.withInputAndStringArgument(ScenesCommand::rename, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "old_name", "new_name")));
        commandBuilder.then(Commands.literal((String)"remove").then(CommandUtils.withInputArgument(ScenesCommand::remove, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "name")));
        commandBuilder.then(Commands.literal((String)"add_to").then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::scene).then(((RequiredArgumentBuilder)Commands.argument((String)"to_add", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(CommandUtils.command(ScenesCommand::addToWithDefaultModifiers))).then(((RequiredArgumentBuilder)Commands.argument((String)"wait_on_start", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(COMMAND_ADD_TO)).then(CommandUtils.playerArguments(buildContext, COMMAND_ADD_TO))))));
        commandBuilder.then(Commands.literal((String)"remove_from").then(CommandUtils.withTwoInputArguments(SceneFiles::removeElement, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::sceneElement), "scene_name", "to_remove")));
        commandBuilder.then(Commands.literal((String)"modify").then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::scene).then(CommandUtils.withModifiers(buildContext, Commands.argument((String)"to_modify", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::sceneElement), CommandUtils.command(ScenesCommand::modify), true))));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"info").then((ArgumentBuilder)CommandUtils.withStringArgument(SceneFiles::info, "scene_name").suggests(CommandSuggestions::scene))).then(CommandUtils.withTwoInputArguments(SceneFiles::elementInfo, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::sceneElement), "scene_name", "element_pos")));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(CommandUtils.command(ScenesCommand::list))).then(CommandUtils.withInputArgument(SceneFiles::listElements, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "scene_name")));
        return commandBuilder;
    }

    public static boolean copy(CommandOutput out, String srcName, String destName) {
        SceneFile srcFile = SceneFile.get(out, srcName);
        SceneFile destFile = SceneFile.get(out, destName);
        if (srcFile == null || destFile == null) {
            return false;
        }
        return srcFile.copy(out, destFile) != null;
    }

    public static boolean rename(CommandOutput out, String srcName, String destName) {
        SceneFile srcFile = SceneFile.get(out, srcName);
        SceneFile destFile = SceneFile.get(out, destName);
        if (srcFile == null || destFile == null) {
            return false;
        }
        return srcFile.rename(out, destFile) != null;
    }

    public static boolean remove(CommandOutput out, String name) {
        SceneFile file = SceneFile.get(out, name);
        return file != null && file.remove(out);
    }

    private static boolean addToWithDefaultModifiers(FullCommandInfo info) {
        try {
            List<String> playableList;
            String name = info.getString("scene_name");
            String toAdd = info.getString("to_add");
            if (!toAdd.contains("*")) {
                SceneData.Element element = new SceneData.Element(toAdd, PlaybackModifiers.DEFAULT);
                return SceneFiles.addElement(info, name, element);
            }
            String[] parts = toAdd.split("\\*", -1);
            if (parts.length != 2) {
                info.sendFailure("scenes.add_to.multiple.invalid_pattern", new Object[0]);
                return false;
            }
            if (toAdd.startsWith(".")) {
                playableList = SceneFiles.list();
            } else if (toAdd.startsWith("-")) {
                playableList = new ArrayList<String>();
                RecordingManager.allContexts().forEach(ctx -> playableList.add(ctx.id.str));
            } else {
                playableList = RecordingFiles.list();
            }
            if (playableList == null) {
                return false;
            }
            int successes = 0;
            int matched = 0;
            for (String str : playableList) {
                if (!str.startsWith(parts[0]) || !str.endsWith(parts[1])) continue;
                SceneData.Element element = new SceneData.Element(str, PlaybackModifiers.DEFAULT);
                successes += SceneFiles.addElement(CommandOutput.LOGS, name, element) ? 1 : 0;
                ++matched;
            }
            if (matched == 0) {
                info.sendFailure("scenes.add_to.multiple.not_found", new Object[0]);
            } else if (successes == matched) {
                info.sendSuccess("scenes.add_to.multiple.success", new Object[0]);
            } else {
                info.sendFailure("scenes.add_to.multiple.error", new Object[0]);
            }
            return successes == matched && matched != 0;
        }
        catch (IllegalArgumentException e) {
            return info.sendException(e, "error.unable_to_get_argument", new Object[0]);
        }
    }

    private static boolean addTo(FullCommandInfo info) {
        try {
            String name = info.getString("scene_name");
            String toAdd = info.getString("to_add");
            if (toAdd.contains("*")) {
                info.sendFailure("scenes.add_to.multiple.pattern_with_arguments", new Object[0]);
                return false;
            }
            double waitOnStart = 0.0;
            try {
                waitOnStart = info.getDouble("wait_on_start");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            MocapModifiers modifiers = info.getSimpleModifiers(info);
            if (modifiers == null) {
                return false;
            }
            MocapTimeModifiers timeModifiers = modifiers.getTimeModifiers().withWaitOnStart(MocapTime.fromSeconds(waitOnStart));
            SceneData.Element element = new SceneData.Element(toAdd, modifiers.withTimeModifiers(timeModifiers));
            return SceneFiles.addElement(info, name, element);
        }
        catch (IllegalArgumentException e) {
            return info.sendException(e, "error.unable_to_get_argument", new Object[0]);
        }
    }

    private static boolean modify(FullCommandInfo info) {
        try {
            String name = info.getString("scene_name");
            Pair<Integer, String> posPair = CommandUtils.splitPosStr(info.getString("to_modify"));
            return SceneFiles.modify(info, name, (Integer)posPair.getFirst(), (String)posPair.getSecond());
        }
        catch (IllegalArgumentException e) {
            info.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return false;
        }
    }

    public static boolean list(CommandOutput out) {
        StringBuilder scenesListStr = new StringBuilder();
        List<String> scenesList = SceneFiles.list();
        if (scenesList == null) {
            scenesListStr.append(" ").append(Utils.stringFromComponent("list.error", new Object[0]));
        } else if (!scenesList.isEmpty()) {
            scenesList.forEach(name -> scenesListStr.append(" ").append((String)name));
        } else {
            scenesListStr.append(" ").append(Utils.stringFromComponent("list.empty", new Object[0]));
        }
        return out.sendSuccess("scenes.list", new String(scenesListStr));
    }
}

