/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.settings.SettingFields;
import net.mt1006.mocap.mocap.settings.SettingGroups;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class SettingsCommand {
    private static final Command<CommandSourceStack> COMMAND_INFO = CommandUtils.command(Settings::info);
    private static final Command<CommandSourceStack> COMMAND_SET = CommandUtils.command(SettingsCommand::set);

    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"settings");
        for (SettingGroups.Group group : Settings.getGroups()) {
            LiteralArgumentBuilder groupBuilder = Commands.literal((String)group.name);
            SettingsCommand.addSettingArguments((LiteralArgumentBuilder<CommandSourceStack>)groupBuilder, group.fields);
            commandBuilder.then((ArgumentBuilder)groupBuilder);
        }
        return commandBuilder;
    }

    private static boolean set(FullCommandInfo info) {
        return Settings.set(info);
    }

    private static void addSettingArguments(LiteralArgumentBuilder<CommandSourceStack> builder, Collection<SettingFields.Field<?>> fields) {
        fields.forEach(f -> builder.then(SettingsCommand.settingArgument(f.name, f.getArgumentType(), f.getSuggestionProvider())));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> settingArgument(String name, ArgumentType<?> argumentType, @Nullable SuggestionProvider<CommandSourceStack> suggestionProvider) {
        RequiredArgumentBuilder arg = Commands.argument((String)"new_value", argumentType);
        if (suggestionProvider != null) {
            arg.suggests(suggestionProvider);
        }
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).executes(COMMAND_INFO)).then(arg.executes(COMMAND_SET));
    }
}

