/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.converter;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import org.jetbrains.annotations.Nullable;

public class AlphaConverter {
    public final double[] mainEntityPos;
    public final Map<Integer, double[]> posByEntity = new HashMap<Integer, double[]>();

    public static boolean command(CommandOutput out, String name) {
        RecordingFile srcFile = RecordingFile.get(out, name);
        if (srcFile == null) {
            return false;
        }
        String backupName = name + "_backup";
        RecordingFile backupFile = RecordingFile.get(out, backupName);
        if (backupFile == null) {
            return false;
        }
        RecordingData data = new RecordingData();
        if (!data.load(out, srcFile, true)) {
            return out.sendFailure("misc.converter.failure", new Object[0]);
        }
        data.setCurrentVersion();
        if (srcFile.rename(out, backupFile) == null) {
            return out.sendFailure("misc.converter.failed_to_rename", name, backupName);
        }
        out.sendSuccess("misc.converter.renamed", name, backupName);
        return RecordingFiles.save(out, srcFile.getFile(), name, data) ? out.sendSuccess("misc.converter.success", new Object[0]) : out.sendFailure("misc.converter.failed_to_save", new Object[0]);
    }

    public AlphaConverter(Vec3 startPos) {
        this.mainEntityPos = new double[3];
        this.mainEntityPos[0] = startPos.x;
        this.mainEntityPos[1] = startPos.y;
        this.mainEntityPos[2] = startPos.z;
    }

    public double @Nullable [] getPosArray(@Nullable Integer entityId) {
        return entityId != null ? (double[])this.posByEntity.getOrDefault(entityId, null) : this.mainEntityPos;
    }
}

