/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.converter;

import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.settings.Settings;

public class AlphaMovement {
    private static final byte Y_SHORT = 1;
    private static final byte Y_FLOAT = 2;
    private static final byte Y_DOUBLE = 3;
    private static final byte XZ_SHORT = 4;
    private static final byte XZ_FLOAT = 8;
    private static final byte XZ_DOUBLE = 12;
    private static final byte ROT_0 = 0;
    private static final byte ROT_HEAD_EQ = 32;
    private static final byte ROT_HEAD_DIFF = 48;
    private static final byte ON_GROUND = 64;
    private static final byte PACKED_Y = -128;
    private static final byte MASK_Y = 3;
    private static final byte MASK_XZ = 12;
    private static final byte MASK_ROT = 48;
    private static final double PACKED_Y_DIV = 4.0;
    private static final double PACKED_XZ_DIV = 2.0;
    private final byte flags;
    private final Vec3 position;
    private final float[] rotation;
    private final float headRot;

    public AlphaMovement(MocapAction.Reader reader) {
        this.flags = reader.readByte();
        double y = switch (this.flags & 3) {
            case 1 -> {
                if ((this.flags & 0xFFFFFF80) != 0) {
                    yield AlphaMovement.unpackValue(reader.readShort(), 4.0);
                }
                yield (double)reader.readShort() / 2.0;
            }
            case 2 -> reader.readFloat();
            case 3 -> reader.readDouble();
            default -> 0.0;
        };
        double x = this.readXZ(reader);
        double z = this.readXZ(reader);
        this.position = new Vec3(x, y, z);
        this.rotation = new float[2];
        if ((this.flags & 0x30) != 0) {
            this.rotation[0] = AlphaMovement.unpackRot(reader.readShort());
            this.rotation[1] = AlphaMovement.unpackRot(reader.readShort());
        }
        this.headRot = switch (this.flags & 0x30) {
            case 32 -> this.rotation[1];
            case 48 -> AlphaMovement.unpackRot(reader.readShort());
            default -> 0.0f;
        };
    }

    private double readXZ(MocapAction.Reader reader) {
        return switch (this.flags & 0xC) {
            case 4 -> AlphaMovement.unpackValue(reader.readShort(), 2.0);
            case 8 -> reader.readFloat();
            case 12 -> reader.readDouble();
            default -> 0.0;
        };
    }

    private static double unpackValue(short packed, double div) {
        return (double)packed / 32767.0 * div;
    }

    private static float unpackRot(short packed) {
        return (float)((double)packed / 65536.0 * 360.0);
    }

    private boolean isYRelative() {
        int yFlags = this.flags & 3;
        boolean yShortAbs = yFlags == 1 && (this.flags & 0xFFFFFF80) == 0;
        return yFlags != 3 && !yShortAbs;
    }

    private boolean isXzRelative() {
        int xzFlags = this.flags & 0xC;
        return xzFlags != 12;
    }

    public void applyToPosition(double[] currentPos) {
        boolean xzRel = this.isXzRelative();
        boolean yRel = this.isYRelative();
        currentPos[0] = xzRel ? currentPos[0] + this.position.x : this.position.x;
        currentPos[1] = yRel ? currentPos[1] + this.position.y : this.position.y;
        currentPos[2] = xzRel ? currentPos[2] + this.position.z : this.position.z;
    }

    public Movement convert(Vec3 startPos, double[] currentPos) {
        byte newFlags = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Vec3 oldPos = new Vec3(currentPos[0], currentPos[1], currentPos[2]);
        this.applyToPosition(currentPos);
        Vec3 newPos = new Vec3(currentPos[0], currentPos[1], currentPos[2]);
        if (oldPos.y != newPos.y) {
            double relNewY = newPos.y - startPos.y;
            double newY2 = newPos.y * 2.0;
            if (newY2 == (double)((short)newY2)) {
                y = newPos.y;
                newFlags = (byte)(newFlags | 3);
            } else if (Math.abs(relNewY) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                y = relNewY;
                newFlags = (byte)(newFlags | 2);
            } else if ((float)relNewY != (float)(oldPos.y - startPos.y)) {
                y = relNewY;
                newFlags = (byte)(newFlags | 1);
            }
        }
        if (oldPos.x != newPos.x || oldPos.z != newPos.z) {
            double relNewX = newPos.x - startPos.x;
            double relNewZ = newPos.z - startPos.z;
            if (Math.abs(relNewX) > (Double)Settings.MAX_FLOAT_POS_VALUE.val || Math.abs(relNewZ) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                x = relNewX;
                z = relNewZ;
                newFlags = (byte)(newFlags | 8);
            } else if ((float)relNewX != (float)(oldPos.x - startPos.x) || (float)relNewZ != (float)(oldPos.z - startPos.z)) {
                x = relNewX;
                z = relNewZ;
                newFlags = (byte)(newFlags | 4);
            }
        }
        newFlags = (byte)(newFlags | (byte)(this.flags & 0x30));
        newFlags = (byte)(newFlags | (byte)(this.flags & 0x40));
        return new Movement(newFlags, new Vec3(x, y, z), this.rotation, this.headRot);
    }
}

