/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.io;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class FullCommandInfo
implements CommandInfo {
    public final CommandContext<CommandSourceStack> ctx;
    public final CommandSourceStack source;
    private final MinecraftServer server;
    private final ServerLevel level;
    @Nullable
    private final ServerPlayer sourcePlayer;
    @Nullable
    private final Entity sourceEntity;

    public FullCommandInfo(CommandContext<CommandSourceStack> ctx) {
        this.ctx = ctx;
        this.source = (CommandSourceStack)ctx.getSource();
        this.server = this.source.getServer();
        this.level = this.source.getLevel();
        this.sourcePlayer = this.source.getPlayer();
        this.sourceEntity = this.source.getEntity();
    }

    @Override
    public boolean sendSuccess(String component, Object ... args) {
        this.source.sendSuccess(() -> this.getTranslatableComponent(component, args), false);
        return true;
    }

    @Override
    public boolean sendSuccessLiteral(String format, Object ... args) {
        this.source.sendSuccess(() -> Component.literal((String)String.format(format, args)), false);
        return true;
    }

    @Override
    public boolean sendSuccessComponent(Component component) {
        this.source.sendSuccess(() -> component, false);
        return true;
    }

    @Override
    public boolean sendFailure(String component, Object ... args) {
        this.source.sendFailure((Component)this.getTranslatableComponent(component, args));
        return false;
    }

    @Override
    public boolean sendFailureWithTip(String component, Object ... args) {
        this.source.sendFailure((Component)this.getTranslatableComponent(component, args));
        if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
            this.source.sendFailure((Component)this.getTranslatableComponent(component + ".tip", new Object[0]));
        }
        return false;
    }

    @Override
    public boolean sendException(Exception exception, String component, Object ... args) {
        this.sendFailure(component, args);
        Utils.exception(exception, Utils.stringFromComponent(component, args));
        return false;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public ServerPlayer getSourcePlayer() {
        return this.sourcePlayer;
    }

    @Override
    @Nullable
    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    @Override
    public String getSourceName() {
        return this.sourcePlayer != null ? this.sourcePlayer.getName().getString() : "+mc";
    }

    @Nullable
    public FullCommandInfo getFinalCommandInfo() {
        CommandContext tempCtx = this.ctx;
        do {
            String command;
            if ((command = CommandUtils.getNode(tempCtx.getNodes(), 0)) == null || !command.equals("mocap") && !command.equals("mocap:mocap")) continue;
            return new FullCommandInfo((CommandContext<CommandSourceStack>)tempCtx);
        } while ((tempCtx = this.ctx.getChild()) != null);
        return null;
    }

    @Nullable
    public String getNode(int pos) {
        return CommandUtils.getNode(this.ctx.getNodes(), pos);
    }

    public int getInteger(String name) {
        return IntegerArgumentType.getInteger(this.ctx, (String)name);
    }

    public double getDouble(String name) {
        return DoubleArgumentType.getDouble(this.ctx, (String)name);
    }

    public boolean getBool(String name) {
        return BoolArgumentType.getBool(this.ctx, (String)name);
    }

    public String getString(String name) {
        return StringArgumentType.getString(this.ctx, (String)name);
    }

    @Nullable
    public String getNullableString(String name) {
        try {
            return StringArgumentType.getString(this.ctx, (String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public MocapPlayerSkin getPlayerSkin() {
        String fromPlayer = this.getNullableString("skin_player_name");
        if (fromPlayer != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_PLAYER, fromPlayer);
        }
        String fromFile = this.getNullableString("skin_filename");
        if (fromFile != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_FILE, fromFile);
        }
        String fromMineskin = this.getNullableString("mineskin_url");
        if (fromMineskin != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_MINESKIN, fromMineskin);
        }
        return PlayerSkin.DEFAULT;
    }

    @Nullable
    public MocapModifiers getSimpleModifiers(CommandOutput out) {
        String playerName = this.getNullableString("player_name");
        if (!PlaybackModifiers.checkIfProperPlayerName(out, playerName)) {
            return null;
        }
        MocapPlayerSkin playerSkin = this.getPlayerSkin();
        if (playerSkin == null) {
            return null;
        }
        PlayerAsEntity playerAsEntity = PlayerAsEntity.DISABLED;
        try {
            Tag tag;
            String playerAsEntityId = ResourceArgument.getEntityType(this.ctx, (String)"entity").key().location().toString();
            try {
                tag = NbtTagArgument.getNbtTag(this.ctx, (String)"nbt");
            }
            catch (Exception e) {
                tag = null;
            }
            CompoundTag nbt = tag instanceof CompoundTag ? (CompoundTag)tag : null;
            playerAsEntity = new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PlaybackModifiers.DEFAULT.withPlayerName(playerName).withPlayerSkin(playerSkin).withPlayerAsEntity(playerAsEntity);
    }
}

