/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.events;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerConnectionEvent {
    private static final int MAX_PLAYER_COUNT = 2048;
    private static final int MAX_NOCOL_PLAYER_COUNT = 4096;
    public static final Set<ServerPlayer> players = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    public static final Set<UUID> nocolPlayers = Collections.synchronizedSet(new HashSet());

    public static void onPlayerJoin(MocapPacketC2S.Client client) {
        MocapPacketS2C.sendOnLogin(client);
    }

    public static void onPlayerLeave(ServerPlayer player) {
        players.remove(player);
        CommandsContext.removePlayer(player);
    }

    public static void addPlayer(@Nullable ServerPlayer player) {
        if (player == null || players.size() >= 2048) {
            return;
        }
        players.add(player);
        players.removeIf(Entity::isRemoved);
    }

    public static void addNocolPlayer(UUID uuid) {
        if (nocolPlayers.size() >= 4096) {
            return;
        }
        nocolPlayers.add(uuid);
    }

    public static void removeNocolPlayer(UUID uuid) {
        nocolPlayers.remove(uuid);
    }

    public static void experimentalReleaseWarning(ServerPlayer player) {
        if (!player.hasPermissions(2) || !((Boolean)Settings.EXPERIMENTAL_RELEASE_WARNING.val).booleanValue()) {
            return;
        }
        Utils.sendComponent((Player)player, (Component)Utils.getTranslatableComponent((Entity)player, "warning.experimental", new Object[0]).append((Component)Utils.getOpenUrlComponent("https://modrinth.com/mod/motion-capture/versions?c=release", Utils.getTranslatableComponent((Entity)player, "warning.experimental.stable_download", new Object[0]))).append((Component)Utils.getOpenUrlComponent("https://discord.gg/nzDETZhqur", Component.literal((String)"\u00a7n[Discord]\u00a7r "))).append((Component)Utils.getOpenUrlComponent("https://github.com/mt1006/mc-mocap-mod", Component.literal((String)"\u00a7n[GitHub]\u00a7r "))).append((Component)Utils.getSuggestCommandComponent("/mocap settings advanced experimental_release_warning false", Utils.getTranslatableComponent((Entity)player, "warning.experimental.disable_message", new Object[0]))));
    }
}

