/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mixin;

import com.mojang.authlib.properties.Property;
import java.util.Collection;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.mt1006.mocap.mocap.playing.skins.CustomClientSkinManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin {
    @Shadow
    @Nullable
    protected abstract PlayerInfo getPlayerInfo();

    @Inject(method={"getSkin"}, at={@At(value="HEAD")}, cancellable=true)
    private void atGetSkinTextureLocation(CallbackInfoReturnable<PlayerSkin> cir) {
        PlayerInfo playerInfo = this.getPlayerInfo();
        if (playerInfo == null) {
            return;
        }
        Collection properties = playerInfo.getProfile().properties().get((Object)"mocap:skin_from_file");
        if (properties.isEmpty()) {
            return;
        }
        ClientAsset.Texture skinTexture = CustomClientSkinManager.get(((Property)properties.iterator().next()).value());
        if (skinTexture == null) {
            return;
        }
        PlayerSkin playerSkin = playerInfo.getSkin();
        cir.setReturnValue((Object)new PlayerSkin(skinTexture, playerSkin.cape(), playerSkin.elytra(), CustomClientSkinManager.isSlimSkin(skinTexture) ? PlayerModelType.SLIM : PlayerModelType.WIDE, playerSkin.secure()));
        cir.cancel();
    }
}

