/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mt1006.mocap.api.v1.extension.MocapExtension;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.command.converter.AlphaMovement;
import net.mt1006.mocap.mocap.actions.BreakBlock;
import net.mt1006.mocap.mocap.actions.BreakBlockProgress;
import net.mt1006.mocap.mocap.actions.ChangeItem;
import net.mt1006.mocap.mocap.actions.ChangePose;
import net.mt1006.mocap.mocap.actions.ChatMessage;
import net.mt1006.mocap.mocap.actions.CloseContainer;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.actions.DummyAction;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.actions.NextTick;
import net.mt1006.mocap.mocap.actions.PlaceBlock;
import net.mt1006.mocap.mocap.actions.PlaceBlockSilently;
import net.mt1006.mocap.mocap.actions.Respawn;
import net.mt1006.mocap.mocap.actions.RightClickBlock;
import net.mt1006.mocap.mocap.actions.SetArrowCount;
import net.mt1006.mocap.mocap.actions.SetEffectParticles;
import net.mt1006.mocap.mocap.actions.SetEntityFlags;
import net.mt1006.mocap.mocap.actions.SetLivingEntityFlags;
import net.mt1006.mocap.mocap.actions.SetMainHand;
import net.mt1006.mocap.mocap.actions.SetNonPlayerEntityData;
import net.mt1006.mocap.mocap.actions.SetSpectator;
import net.mt1006.mocap.mocap.actions.SkipTicks;
import net.mt1006.mocap.mocap.actions.Sleep;
import net.mt1006.mocap.mocap.actions.Swing;
import net.mt1006.mocap.mocap.actions.deprecated.HeadRotation;
import net.mt1006.mocap.mocap.actions.deprecated.MovementLegacy;
import net.mt1006.mocap.mocap.actions.deprecated.SetEffectColor;
import net.mt1006.mocap.mocap.actions.deprecated.SetVehicleData;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import org.jetbrains.annotations.Nullable;

public enum ActionType {
    NEXT_TICK(0, reader -> NextTick.INSTANCE),
    MOVEMENT_LEGACY(1, MovementLegacy::new),
    HEAD_ROTATION(2, HeadRotation::new),
    CHANGE_POSE(3, ChangePose::new, ChangePose::new),
    CHANGE_ITEM(4, ChangeItem::new, ChangeItem::fromEntity),
    SET_ENTITY_FLAGS(5, SetEntityFlags::new, SetEntityFlags::new),
    SET_LIVING_ENTITY_FLAGS(6, SetLivingEntityFlags::new, SetLivingEntityFlags::fromEntity),
    SET_MAIN_HAND(7, SetMainHand::new, SetMainHand::fromEntity),
    SWING(8, Swing::new, Swing::fromEntity),
    BREAK_BLOCK(9, BreakBlock::new),
    PLACE_BLOCK(10, PlaceBlock::new),
    RIGHT_CLICK_BLOCK(11, RightClickBlock::new),
    SET_EFFECT_COLOR(12, SetEffectColor::new),
    SET_ARROW_COUNT(13, SetArrowCount::new, SetArrowCount::fromEntity),
    SLEEP(14, Sleep::new, Sleep::new),
    PLACE_BLOCK_SILENTLY(15, PlaceBlockSilently::new),
    ENTITY_UPDATE(16, EntityUpdate::new),
    ENTITY_ACTION(17, EntityAction::new),
    HURT(18, Hurt::skipByteAndGetInstance),
    SET_VEHICLE_DATA(19, SetVehicleData::new),
    BREAK_BLOCK_PROGRESS(20, BreakBlockProgress::new),
    MOVEMENT(21, Movement::new),
    SKIP_TICKS(22, SkipTicks::new),
    DIE(23, reader -> Die.INSTANCE),
    RESPAWN(24, reader -> Respawn.INSTANCE),
    CHAT_MESSAGE(25, ChatMessage::new),
    SET_SPECTATOR(26, SetSpectator::new, SetSpectator::new),
    DUMMY(27, reader -> DummyAction.INSTANCE),
    CLOSE_CONTAINER(28, reader -> CloseContainer.INSTANCE),
    SET_EFFECT_PARTICLES(29, SetEffectParticles::new, SetEffectParticles::fromEntity),
    SET_NON_PLAYER_ENTITY_DATA(30, SetNonPlayerEntityData::new, SetNonPlayerEntityData::fromEntity);

    public final byte id;

    private ActionType(int id, MocapAction.FromReaderOnly fromReaderOnly) {
        this(id, (reader, data) -> (MocapAction)fromReaderOnly.apply(reader));
    }

    private ActionType(@Nullable int id, MocapAction.FromReaderOnly fromReaderOnly, MocapAction.FromEntity fromEntity) {
        this(id, (reader, data) -> (MocapAction)fromReaderOnly.apply(reader), fromEntity);
    }

    private ActionType(int id, MocapAction.FromReader fromReader) {
        this.id = (byte)id;
        Registry.MAIN.register(id, fromReader, null);
    }

    private ActionType(@Nullable int id, MocapAction.FromReader fromReader, MocapAction.FromEntity fromEntity) {
        this.id = (byte)id;
        Registry.MAIN.register(id, fromReader, fromEntity);
    }

    private void init() {
    }

    public static void initTypes() {
        if (Registry.MAIN.actions.isEmpty()) {
            for (ActionType type : ActionType.values()) {
                type.init();
            }
        }
    }

    public static void prepareToWriteAction(RecordingData data, MocapAction action) {
        Pair<MocapExtension, Byte> extensionActionData;
        MocapExtension extension;
        if (Registry.mainIdMap.get(action.getClass()) == -1 && data.getExtensionId(extension = (MocapExtension)(extensionActionData = Registry.extensionActionMap.get(action.getClass())).getFirst()) == null) {
            data.initAndAddExtension(extension);
        }
        action.prepareWrite(data);
    }

    public static void writeAction(MocapAction.Writer writer, MocapRecordingData data, MocapAction action) {
        byte id = Registry.mainIdMap.get(action.getClass());
        writer.addByte(id);
        if (id == -1) {
            Pair<MocapExtension, Byte> extensionActionData = Registry.extensionActionMap.get(action.getClass());
            Byte extensionId = data.getExtensionId((MocapExtension)extensionActionData.getFirst());
            if (extensionId == null) {
                throw new RuntimeException("Extension wasn't initialized!");
            }
            writer.addByte(extensionId);
            writer.addByte((Byte)extensionActionData.getSecond());
            RecordingFiles.Writer actionWriter = new RecordingFiles.Writer();
            action.write(actionWriter, data);
            writer.addPackedInt(actionWriter.getSize());
            actionWriter.copyToWriter(writer);
        } else {
            action.write(writer, data);
        }
    }

    @Nullable
    public static MocapAction readAction(MocapAction.Reader reader, MocapRecordingData data, @Nullable AlphaConverter converter, @Nullable Integer converterEntityId) {
        MocapAction.FromReader constructor;
        Registry registry = Registry.MAIN;
        byte id = reader.readByte();
        if (converter != null) {
            if (id == ActionType.MOVEMENT.id) {
                AlphaMovement alphaMovement = new AlphaMovement(reader);
                double[] posArray = converter.getPosArray(converterEntityId);
                return posArray != null ? alphaMovement.convert(data.getStartPos(), posArray) : null;
            }
            if (id == ActionType.CHAT_MESSAGE.id) {
                return new ChatMessage(reader.readString());
            }
            if (id == ActionType.ENTITY_ACTION.id) {
                return new EntityAction(reader, data, converter);
            }
            if (id == ActionType.ENTITY_UPDATE.id) {
                return new EntityUpdate(reader, converter, 0);
            }
        }
        if (id == -1) {
            MocapExtension extension = data.getExtension(reader.readByte());
            id = reader.readByte();
            int size = reader.readPackedInt();
            if (extension == null) {
                reader.shift(size);
                return DummyAction.INSTANCE;
            }
            registry = extension.getActionRegistry();
        }
        return (constructor = registry.actions.get(Byte.toUnsignedInt(id))) != null ? (MocapAction)constructor.apply(reader, data) : null;
    }

    public static class Registry {
        private static final Registry MAIN = new Registry(null);
        private static final byte CUSTOM_ACTION_ID = -1;
        public static final List<MocapAction.FromEntity> allComparableActions = new ArrayList<MocapAction.FromEntity>();
        public static final Map<Class<?>, Byte> mainIdMap = new HashMap();
        private static final Map<Class<?>, Pair<MocapExtension, Byte>> extensionActionMap = new HashMap();
        @Nullable
        private final MocapExtension extension;
        private final List<MocapAction.FromReader> actions = new ArrayList<MocapAction.FromReader>();
        private int lastRegisteredId = -1;

        public Registry(@Nullable MocapExtension extension) {
            this.extension = extension;
        }

        public void register(int id, MocapAction.FromReader fromReader, @Nullable MocapAction.FromEntity fromEntity) {
            MocapAction instance = (MocapAction)fromReader.apply(RecordingFiles.DUMMY_READER, RecordingData.DUMMY);
            if (fromEntity == null && instance instanceof MocapStateAction) {
                throw new RuntimeException("Tried to register MocapStateAction without \"fromEntity\" constructor!");
            }
            if (id > 254) {
                throw new RuntimeException("Tried to register an Action with ID higher than 254!");
            }
            if (id != this.lastRegisteredId + 1) {
                throw new RuntimeException("Tried to register an Action with id out of order!");
            }
            this.lastRegisteredId = id;
            if (fromEntity != null) {
                allComparableActions.add(fromEntity);
            }
            mainIdMap.put(instance.getClass(), (byte)(this.extension == null ? id : 255));
            extensionActionMap.put(instance.getClass(), (Pair<MocapExtension, Byte>)Pair.of((Object)this.extension, (Object)((byte)id)));
            this.actions.add(fromReader);
        }
    }
}

