/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.mt1006.mocap.api.v1.extension.MocapBlockState;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapBasicActionContext;

public class BlockStateData
implements MocapBlockState {
    private final BlockState blockState;
    private int idToWrite = -1;

    public BlockStateData(BlockState blockState) {
        this.blockState = blockState;
    }

    public BlockStateData(MocapAction.Reader reader, MocapRecordingData data) {
        this.blockState = data.blockStateFromId(reader.readInt());
    }

    @Override
    public BlockState get() {
        return this.blockState;
    }

    @Override
    public void prepareWrite(MocapRecordingData data) {
        this.idToWrite = data.provideBlockStateId(this.blockState);
    }

    @Override
    public void write(MocapAction.Writer writer) {
        if (this.idToWrite == -1) {
            throw new RuntimeException("BlockStateData write wasn't prepared!");
        }
        writer.addInt(this.idToWrite);
    }

    @Override
    public void place(MocapBasicActionContext ctx, BlockPos blockPos) {
        Entity entity = ctx.getEntity();
        ServerLevel level = ctx.getLevel();
        BlockState finBlockState = ctx.getTransformer().transformBlockState(this.blockState);
        ctx.getTransformer().transformBlockPos(blockPos, ctx.getConfig().getBlockAllowScaled()).forEach(arg_0 -> BlockStateData.lambda$place$0(entity, (Level)level, finBlockState, arg_0));
    }

    @Override
    public void placeSilently(MocapBasicActionContext ctx, BlockPos blockPos) {
        ServerLevel level = ctx.getLevel();
        BlockState finBlockState = ctx.getTransformer().transformBlockState(this.blockState);
        ctx.getTransformer().transformBlockPos(blockPos, ctx.getConfig().getBlockAllowScaled()).forEach(arg_0 -> BlockStateData.lambda$placeSilently$1((Level)level, finBlockState, arg_0));
    }

    private static void placeSingle(Entity entity, Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.isAir()) {
            level.destroyBlock(blockPos, true);
        } else {
            level.setBlock(blockPos, blockState, 3);
            SoundType soundType = blockState.getSoundType();
            level.playSound(entity, blockPos, blockState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        }
    }

    private static void placeSingleSilently(Level level, BlockPos blockPos, BlockState blockState) {
        level.setBlock(blockPos, blockState, 3);
    }

    private static /* synthetic */ void lambda$placeSilently$1(Level level, BlockState finBlockState, BlockPos block) {
        BlockStateData.placeSingleSilently(level, block, finBlockState);
    }

    private static /* synthetic */ void lambda$place$0(Entity entity, Level level, BlockState finBlockState, BlockPos block) {
        BlockStateData.placeSingle(entity, level, block, finBlockState);
    }
}

