/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mixin.fields.LivingEntityFields;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class ChangeItem
implements MocapStateAction {
    private static final int ITEM_COUNT_LEGACY = 6;
    private static final int ITEM_COUNT = 8;
    private final byte itemCount;
    private final List<ItemData> items = new ArrayList<ItemData>();

    @Nullable
    public static ChangeItem fromEntity(Entity entity) {
        ChangeItem changeItem;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            changeItem = new ChangeItem(livingEntity);
        } else {
            changeItem = null;
        }
        return changeItem;
    }

    private ChangeItem(LivingEntity entity) {
        RegistryOps ops = entity.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.addItem(entity.getMainHandItem(), (DynamicOps<Tag>)ops);
        this.addItem(entity.getOffhandItem(), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.FEET), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.LEGS), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.CHEST), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.HEAD), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.BODY), (DynamicOps<Tag>)ops);
        this.addItem(entity.getItemBySlot(EquipmentSlot.SADDLE), (DynamicOps<Tag>)ops);
        int itemCounter = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get((int)i).type == ItemDataType.NO_ITEM) continue;
            itemCounter = i + 1;
        }
        this.itemCount = (byte)itemCounter;
    }

    public ChangeItem(MocapAction.Reader reader, MocapRecordingData data) {
        byte firstByte = reader.readByte();
        if (firstByte >= 0) {
            reader.shift(-1);
            this.itemCount = (byte)6;
        } else {
            this.itemCount = firstByte != -128 ? -firstByte : (byte)0;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.add(new ItemData(reader, data));
        }
    }

    private void addItem(@Nullable ItemStack itemStack, DynamicOps<Tag> ops) {
        this.items.add(ItemData.get(itemStack, ops));
    }

    private void setEntityItems(LivingEntity entity) {
        RegistryOps ops = entity.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (int i = 0; i < 8; ++i) {
            ItemData item = i < this.itemCount ? this.items.get(i) : ItemData.EMPTY;
            ItemStack itemStack = item.getItemStack((DynamicOps<Tag>)ops);
            switch (i) {
                case 0: {
                    entity.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
                    break;
                }
                case 1: {
                    entity.setItemSlot(EquipmentSlot.OFFHAND, itemStack);
                    break;
                }
                case 2: {
                    entity.setItemSlot(EquipmentSlot.FEET, itemStack);
                    break;
                }
                case 3: {
                    entity.setItemSlot(EquipmentSlot.LEGS, itemStack);
                    break;
                }
                case 4: {
                    entity.setItemSlot(EquipmentSlot.CHEST, itemStack);
                    break;
                }
                case 5: {
                    entity.setItemSlot(EquipmentSlot.HEAD, itemStack);
                    break;
                }
                case 6: {
                    entity.setItemSlot(EquipmentSlot.BODY, itemStack);
                    break;
                }
                case 7: {
                    entity.setItemSlot(EquipmentSlot.SADDLE, itemStack);
                }
            }
            if (!(entity instanceof Player)) continue;
            ((LivingEntityFields)entity).callDetectEquipmentUpdates();
        }
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        if (this.itemCount != ((ChangeItem)previousAction).itemCount) {
            return true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ItemData item2;
            ItemData item1 = this.items.get(i);
            if (!item1.differs(item2 = ((ChangeItem)previousAction).items.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeInitialized() {
        return this.itemCount != 0;
    }

    @Override
    public void prepareWrite(MocapRecordingData data) {
        if (this.itemCount > this.items.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).prepareWrite(data);
        }
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.itemCount > 0 ? (byte)(-this.itemCount) : (byte)-128);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).write(writer);
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        LivingEntity livingEntity = ctx.getLivingEntityOrDummyPlayer();
        if (livingEntity == null) {
            return MocapAction.Result.IGNORED;
        }
        this.setEntityItems(livingEntity);
        return MocapAction.Result.OK;
    }

    private static class ItemData {
        public static final ItemData EMPTY = new ItemData();
        public final ItemDataType type;
        public final Item item;
        public final String data;
        private int idToWrite = -1;

        private ItemData() {
            this.type = ItemDataType.NO_ITEM;
            this.item = Items.AIR;
            this.data = "";
        }

        private ItemData(ItemStack itemStack, DynamicOps<Tag> ops) {
            Tag tag;
            this.item = itemStack.getItem();
            try {
                tag = (Tag)ItemStack.CODEC.encodeStart(ops, (Object)itemStack).getOrThrow();
            }
            catch (Exception exception) {
                tag = null;
            }
            if (!(tag instanceof CompoundTag) || !((CompoundTag)tag).contains("components")) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            Tag componentsTag = ((CompoundTag)tag).get("components");
            if (!(componentsTag instanceof CompoundTag)) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            this.type = ItemDataType.ID_AND_COMPONENTS;
            this.data = componentsTag.toString();
        }

        public ItemData(MocapAction.Reader reader, MocapRecordingData recordingData) {
            this.type = ItemDataType.get(reader.readByte());
            int itemId = this.type.hasId ? reader.readInt() : 0;
            String string = this.data = this.type.hasData ? reader.readString() : "";
            if (recordingData == null) {
                this.item = Items.AIR;
                return;
            }
            this.item = recordingData.itemFromId(itemId);
        }

        public static ItemData get(@Nullable ItemStack itemStack, DynamicOps<Tag> ops) {
            return itemStack == null || itemStack.isEmpty() ? EMPTY : new ItemData(itemStack, ops);
        }

        public boolean differs(ItemData itemData) {
            return this.type != itemData.type || this.item != itemData.item || !this.data.equals(itemData.data);
        }

        public void prepareWrite(MocapRecordingData recordingData) {
            this.idToWrite = recordingData.provideItemId(this.item);
        }

        public void write(MocapAction.Writer writer) {
            if (this.idToWrite == -1) {
                throw new RuntimeException("ItemData write wasn't prepared!");
            }
            writer.addByte(this.type.id);
            if (this.type.hasId) {
                writer.addInt(this.idToWrite);
            }
            if (this.type.hasData) {
                writer.addString(this.data);
            }
        }

        public ItemStack getItemStack(DynamicOps<Tag> ops) {
            switch (this.type.ordinal()) {
                case 0: {
                    return ItemStack.EMPTY;
                }
                case 1: 
                case 2: {
                    return new ItemStack((ItemLike)this.item);
                }
                case 3: {
                    CompoundTag tag = this.tagFromIdAndComponents();
                    if (tag == null) {
                        return ItemStack.EMPTY;
                    }
                    try {
                        return (ItemStack)ItemStack.CODEC.parse(ops, (Object)tag).getOrThrow();
                    }
                    catch (Exception e) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            return null;
        }

        @Nullable
        private CompoundTag tagFromIdAndComponents() {
            CompoundTag tag = new CompoundTag();
            try {
                tag.put("components", (Tag)Utils.nbtFromString(this.data));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            tag.put("id", (Tag)StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)this.item).toString()));
            tag.put("count", (Tag)IntTag.valueOf((int)1));
            return tag;
        }
    }

    private static enum ItemDataType {
        NO_ITEM(0, false, false),
        ID_ONLY(1, true, false),
        ID_AND_NBT(2, true, true),
        ID_AND_COMPONENTS(3, true, true);

        private static final ItemDataType[] VALUES;
        public final byte id;
        public final boolean hasId;
        public final boolean hasData;

        private ItemDataType(int id, boolean hasId, boolean hasData) {
            this.id = (byte)id;
            this.hasId = hasId;
            this.hasData = hasData;
        }

        public static ItemDataType get(byte id) {
            if (id < 0 || id >= VALUES.length) {
                return NO_ITEM;
            }
            ItemDataType type = VALUES[id];
            if (type.id != id) {
                throw new RuntimeException("ChangeItem.ItemDataType VALUES out of order!");
            }
            return type;
        }

        static {
            VALUES = ItemDataType.values();
        }
    }
}

