/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;

public class ChatMessage
implements MocapAction {
    private final String messageJson;

    public ChatMessage(Component component) {
        String message;
        try {
            message = ((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)component).getOrThrow()).toString();
        }
        catch (IllegalStateException e) {
            message = "{}";
        }
        this.messageJson = message;
    }

    public ChatMessage(String messageJson) {
        this.messageJson = messageJson;
    }

    public ChatMessage(MocapAction.Reader reader) {
        reader.readByte();
        this.messageJson = reader.readString();
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte((byte)0);
        writer.addString(this.messageJson);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        UUID senderUUID;
        Component message;
        if (!ctx.getConfig().getChatPlayback()) {
            return MocapAction.Result.IGNORED;
        }
        ServerPlayer player = ctx.getRealOrDummyPlayer();
        if (player == null) {
            return MocapAction.Result.IGNORED;
        }
        MinecraftServer server = ctx.getLevel().getServer();
        try {
            message = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse(this.messageJson)).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            return MocapAction.Result.IGNORED;
        }
        if (message == null) {
            return MocapAction.Result.IGNORED;
        }
        if (player != ctx.getEntity()) {
            List playerList = ctx.getLevel().getServer().getPlayerList().getPlayers();
            if (playerList.isEmpty()) {
                return MocapAction.Result.IGNORED;
            }
            senderUUID = ((ServerPlayer)playerList.get(0)).getUUID();
        } else {
            senderUUID = player.getUUID();
        }
        PlayerChatMessage chatMessage = PlayerChatMessage.unsigned((UUID)senderUUID, (String)message.getString()).withUnsignedContent(message);
        server.getPlayerList().broadcastChatMessage(chatMessage, player, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)player));
        return MocapAction.Result.OK;
    }
}

