/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.controller.config.MocapNbtRecordingMode;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mixin.fields.EntityIdFields;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class EntityUpdate
implements MocapAction {
    private final UpdateType type;
    private final int id;
    @Nullable
    private final String nbtString;
    @Nullable
    private final Vec3 position;

    public static EntityUpdate addEntity(int id, Entity entity, MocapRecordingConfig config) {
        String nbtString = EntityUpdate.serializeEntityNBT(entity, config).toString();
        return new EntityUpdate(UpdateType.ADD, id, nbtString, entity.position());
    }

    public static EntityUpdate removeEntity(int id) {
        return new EntityUpdate(UpdateType.REMOVE, id, null, null);
    }

    public static EntityUpdate kill(int id) {
        return new EntityUpdate(UpdateType.KILL, id, null, null);
    }

    public static EntityUpdate hurt(int id) {
        return new EntityUpdate(UpdateType.HURT, id, null, null);
    }

    public static EntityUpdate playerMount(int id) {
        return new EntityUpdate(UpdateType.PLAYER_MOUNT, id, null, null);
    }

    public static EntityUpdate playerDismount() {
        return new EntityUpdate(UpdateType.PLAYER_DISMOUNT, 0, null, null);
    }

    private EntityUpdate(UpdateType type, int id, @Nullable String nbtString, @Nullable Vec3 position) {
        this.type = type;
        this.id = id;
        this.nbtString = nbtString;
        this.position = position;
    }

    public EntityUpdate(MocapAction.Reader reader) {
        this(reader, null, 0);
    }

    public EntityUpdate(MocapAction.Reader reader, @Nullable AlphaConverter converter, int dummy) {
        this.type = UpdateType.fromId(reader.readByte());
        this.id = reader.readInt();
        if (this.type == UpdateType.ADD) {
            this.nbtString = reader.readString();
            this.position = reader.readVec3();
            if (converter != null) {
                converter.posByEntity.put(this.id, new double[]{this.position.x, this.position.y, this.position.z});
            }
        } else {
            this.nbtString = null;
            this.position = null;
        }
    }

    public static CompoundTag serializeEntityNBT(Entity entity, MocapRecordingConfig config) {
        TagValueOutput tagOutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)entity.registryAccess());
        String id = ((EntityIdFields)entity).callGetEncodeId();
        tagOutput.putString("id", id != null ? id : "minecraft:cow");
        if (config.getNbtRecordingMode() != MocapNbtRecordingMode.DISABLED) {
            entity.saveWithoutId((ValueOutput)tagOutput);
        }
        CompoundTag nbt = tagOutput.buildResult();
        nbt.remove("UUID");
        nbt.remove("Pos");
        nbt.remove("Motion");
        if (config.getNbtRecordingMode() == MocapNbtRecordingMode.FILTERED) {
            EntityUpdate.filterEntityNBT(nbt, entity);
        }
        return nbt;
    }

    public static void filterEntityNBT(CompoundTag nbt, Entity entity) {
        nbt.remove("Brain");
        nbt.remove("EggLayTime");
        nbt.remove("CanPickUpLoot");
        nbt.remove("NoAI");
        nbt.remove("ForcedAge");
        nbt.remove("EggLayTime");
        nbt.remove("fall_distance");
        if (nbt.getShortOr("HurtTime", (short)-1) == 0) {
            nbt.remove("HurtTime");
        }
        if (nbt.getShortOr("DeathTime", (short)-1) == 0) {
            nbt.remove("DeathTime");
        }
        if (nbt.getIntOr("HurtByTimestamp", -1) == 0) {
            nbt.remove("HurtByTimestamp");
        }
        if (nbt.getShortOr("Air", (short)-1) == entity.getMaxAirSupply()) {
            nbt.remove("Air");
        }
        if (nbt.getFloatOr("AbsorptionAmount", -1.0f) == 0.0f) {
            nbt.remove("AbsorptionAmount");
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (nbt.getFloatOr("Health", -1.0f) == living.getMaxHealth()) {
                nbt.remove("Health");
            }
        }
        if (nbt.getIntOr("Age", -1) >= 0) {
            nbt.remove("Age");
        } else {
            nbt.putInt("Age", -9);
        }
        ListTag listTag = nbt.getList("attributes").orElse(null);
        if (listTag != null) {
            ListTag newListTag = new ListTag();
            for (Tag tag : listTag) {
                ResourceLocation attributeId;
                CompoundTag attribute = tag.asCompound().orElse(null);
                String attributeIdStr = attribute != null ? (String)attribute.getString("id").orElse(null) : null;
                ResourceLocation resourceLocation = attributeId = attributeIdStr != null ? ResourceLocation.tryParse((String)attributeIdStr) : null;
                if (attributeId == null) {
                    newListTag.add((Object)tag);
                    continue;
                }
                if (Attributes.FOLLOW_RANGE.is(attributeId) || Attributes.ATTACK_DAMAGE.is(attributeId) || Attributes.FALL_DAMAGE_MULTIPLIER.is(attributeId) || Attributes.SAFE_FALL_DISTANCE.is(attributeId)) continue;
                newListTag.add((Object)tag);
            }
            if (newListTag.isEmpty()) {
                nbt.remove("attributes");
            } else {
                nbt.put("attributes", (Tag)newListTag);
            }
        }
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.type.id);
        writer.addInt(this.id);
        if (this.type == UpdateType.ADD) {
            writer.addString(this.nbtString != null ? this.nbtString : "");
            writer.addVec3(this.position != null ? this.position : Vec3.ZERO);
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        switch (this.type.ordinal()) {
            case 1: {
                return this.executeAdd(ctx);
            }
            case 6: {
                ctx.getEntity().stopRiding();
                return MocapAction.Result.OK;
            }
            case 0: {
                return MocapAction.Result.IGNORED;
            }
        }
        MocapActionContext.EntityData entityData = ctx.getEntityData(this.id);
        if (entityData == null) {
            return MocapAction.Result.IGNORED;
        }
        Entity entity = entityData.entity;
        switch (this.type.ordinal()) {
            case 2: {
                entity.remove(Entity.RemovalReason.KILLED);
                return MocapAction.Result.OK;
            }
            case 3: {
                entity.invulnerableTime = 0;
                entity.kill(ctx.getLevel());
                return MocapAction.Result.OK;
            }
            case 4: {
                Hurt.hurtEntity(entity, ctx.getConfig());
                return MocapAction.Result.OK;
            }
            case 5: {
                ctx.getEntity().startRiding(entity, true, true);
                return MocapAction.Result.OK;
            }
        }
        return MocapAction.Result.IGNORED;
    }

    private MocapAction.Result executeAdd(MocapActionContext ctx) {
        CompoundTag compoundTag;
        MocapEntityFilter filter = ctx.getModifiers().getEntityFilter();
        if (this.nbtString == null || this.position == null || ctx.hasEntity(this.id) || filter.isEmpty()) {
            return MocapAction.Result.IGNORED;
        }
        try {
            compoundTag = Utils.nbtFromString(this.nbtString);
        }
        catch (Exception e) {
            Utils.exception(e, "Exception occurred when parsing entity NBT data!");
            return MocapAction.Result.ERROR;
        }
        ValueInput nbt = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)ctx.getEntity().registryAccess(), (CompoundTag)compoundTag);
        Entity entity = EntityType.create((ValueInput)nbt, (Level)ctx.getLevel(), (EntitySpawnReason)EntitySpawnReason.MOB_SUMMONED).orElse(null);
        if (entity == null || !filter.isAllowed(entity)) {
            return MocapAction.Result.IGNORED;
        }
        entity.setPos(ctx.getTransformer().transformPos(this.position));
        entity.setDeltaMovement(0.0, 0.0, 0.0);
        entity.setNoGravity(true);
        entity.setInvulnerable(ctx.getConfig().getInvulnerablePlayback());
        entity.addTag("mocap_entity");
        if (entity instanceof Mob) {
            ((Mob)entity).setNoAi(true);
        }
        ctx.getModifiers().getTransformations().applyScaleToEntity(entity);
        ctx.getLevel().addFreshEntity(entity);
        ctx.addEntity(this.id, entity, this.position);
        return MocapAction.Result.OK;
    }

    public static enum UpdateType {
        NONE(0),
        ADD(1),
        REMOVE(2),
        KILL(3),
        HURT(4),
        PLAYER_MOUNT(5),
        PLAYER_DISMOUNT(6);

        private static final UpdateType[] VALUES;
        private final byte id;

        private UpdateType(int id) {
            this.id = (byte)id;
        }

        private static UpdateType fromId(byte id) {
            for (UpdateType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return NONE;
        }

        static {
            VALUES = UpdateType.values();
        }
    }
}

