/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.mixin.fields.EntityFields;
import net.mt1006.mocap.utils.FakePlayer;

public class Respawn
implements MocapAction {
    public static final Respawn INSTANCE = new Respawn();

    private Respawn() {
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        Entity entity = ctx.getEntity();
        entity.setPose(Pose.STANDING);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setHealth(livingEntity.getMaxHealth());
            livingEntity.deathTime = 0;
        }
        if (entity instanceof FakePlayer) {
            UUID uuid = entity.getUUID();
            ctx.broadcast((Packet<?>)new ClientboundPlayerInfoRemovePacket(List.of(uuid)));
            ctx.getLevel().removePlayerImmediately((ServerPlayer)((FakePlayer)entity), Entity.RemovalReason.KILLED);
            ((FakePlayer)entity).fakeRespawn();
            ctx.getLevel().getServer().getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)((FakePlayer)entity)));
            ctx.getLevel().addNewPlayer((ServerPlayer)((FakePlayer)entity));
        } else {
            ((EntityFields)entity).callUnsetRemoved();
            ctx.getLevel().addFreshEntity(entity);
        }
        return MocapAction.Result.OK;
    }
}

