/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapBasicActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapBlockAction;

public class RightClickBlock
implements MocapBlockAction {
    private final BlockHitResult blockHitResult;
    private final boolean offHand;

    public RightClickBlock(BlockHitResult blockHitResult, boolean offHand) {
        this.blockHitResult = blockHitResult;
        this.offHand = offHand;
    }

    public RightClickBlock(MocapAction.Reader reader) {
        Vec3 pos = reader.readVec3();
        BlockPos blockPos = reader.readBlockPos();
        Direction direction = this.directionFromByte(reader.readByte());
        boolean inside = reader.readBoolean();
        this.blockHitResult = new BlockHitResult(pos, direction, blockPos, inside);
        this.offHand = reader.readBoolean();
    }

    private Direction directionFromByte(byte val) {
        return switch (val) {
            case 1 -> Direction.UP;
            case 2 -> Direction.NORTH;
            case 3 -> Direction.SOUTH;
            case 4 -> Direction.WEST;
            case 5 -> Direction.EAST;
            default -> Direction.DOWN;
        };
    }

    private byte directionToByte(Direction direction) {
        return switch (direction) {
            case Direction.UP -> 1;
            case Direction.NORTH -> 2;
            case Direction.SOUTH -> 3;
            case Direction.WEST -> 4;
            case Direction.EAST -> 5;
            default -> 0;
        };
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addVec3(this.blockHitResult.getLocation());
        writer.addBlockPos(this.blockHitResult.getBlockPos());
        writer.addByte(this.directionToByte(this.blockHitResult.getDirection()));
        writer.addBoolean(this.blockHitResult.isInside());
        writer.addBoolean(this.offHand);
    }

    @Override
    public void initBlocks(MocapBasicActionContext ctx) {
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        ServerPlayer player = ctx.getRealOrDummyPlayer();
        if (player == null) {
            return MocapAction.Result.IGNORED;
        }
        InteractionHand interactionHand = this.offHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        boolean allowScaled = ctx.getConfig().getBlockAllowScaled();
        for (BlockPos blockPos : ctx.getTransformer().transformBlockPos(this.blockHitResult.getBlockPos(), allowScaled)) {
            InteractionResult result;
            BlockState blockState = ctx.getLevel().getBlockState(blockPos);
            if (blockState.getBlock() instanceof BedBlock || (result = blockState.useItemOn(itemStack, (Level)ctx.getLevel(), (Player)player, interactionHand, this.blockHitResult)) != InteractionResult.TRY_WITH_EMPTY_HAND) continue;
            blockState.useWithoutItem((Level)ctx.getLevel(), (Player)player, this.blockHitResult);
        }
        return MocapAction.Result.OK;
    }
}

