/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import org.jetbrains.annotations.Nullable;

public class SetArrowCount
implements MocapStateAction {
    private final int arrowCount;
    private final int beeStingerCount;

    @Nullable
    public static SetArrowCount fromEntity(Entity entity) {
        SetArrowCount setArrowCount;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            setArrowCount = new SetArrowCount(livingEntity);
        } else {
            setArrowCount = null;
        }
        return setArrowCount;
    }

    private SetArrowCount(LivingEntity entity) {
        this.arrowCount = entity.getArrowCount();
        this.beeStingerCount = entity.getStingerCount();
    }

    public SetArrowCount(MocapAction.Reader reader) {
        this.arrowCount = reader.readInt();
        this.beeStingerCount = reader.readInt();
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return this.arrowCount != ((SetArrowCount)previousAction).arrowCount || this.beeStingerCount != ((SetArrowCount)previousAction).beeStingerCount;
    }

    @Override
    public boolean shouldBeInitialized() {
        return this.arrowCount != 0 || this.beeStingerCount != 0;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addInt(this.arrowCount);
        writer.addInt(this.beeStingerCount);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!(ctx.getEntity() instanceof LivingEntity)) {
            return MocapAction.Result.IGNORED;
        }
        ((LivingEntity)ctx.getEntity()).setArrowCount(this.arrowCount);
        ((LivingEntity)ctx.getEntity()).setStingerCount(this.beeStingerCount);
        return MocapAction.Result.OK;
    }
}

