/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

public class SetEffectParticles
implements MocapStateAction {
    private final Set<String> particleJsonSet = new TreeSet<String>();
    private final boolean ambience;

    @Nullable
    public static SetEffectParticles fromEntity(Entity entity) {
        SetEffectParticles setEffectParticles;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            setEffectParticles = new SetEffectParticles(livingEntity);
        } else {
            setEffectParticles = null;
        }
        return setEffectParticles;
    }

    private SetEffectParticles(LivingEntity entity) {
        for (ParticleOptions particle : EntityData.LIVING_ENTITY_EFFECT_PARTICLES.valOrDef((Entity)entity, List.of())) {
            JsonElement jsonElement = ParticleTypes.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)particle).result().orElse(null);
            if (jsonElement == null) continue;
            this.particleJsonSet.add(jsonElement.toString());
        }
        this.ambience = EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.valOrDef((Entity)entity, false);
    }

    public SetEffectParticles(MocapAction.Reader reader) {
        int count = reader.readPackedInt();
        for (int i = 0; i < count; ++i) {
            String particleJson = reader.readString();
            this.particleJsonSet.add(particleJson);
        }
        this.ambience = reader.readBoolean();
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return !this.particleJsonSet.equals(((SetEffectParticles)previousAction).particleJsonSet) || this.ambience != ((SetEffectParticles)previousAction).ambience;
    }

    @Override
    public boolean shouldBeInitialized() {
        return !this.particleJsonSet.isEmpty() || this.ambience;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addPackedInt(this.particleJsonSet.size());
        this.particleJsonSet.forEach(writer::addString);
        writer.addBoolean(this.ambience);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        Entity entity = ctx.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return MocapAction.Result.IGNORED;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ArrayList<ParticleOptions> particles = new ArrayList<ParticleOptions>();
        for (String jsonStr : this.particleJsonSet) {
            try {
                particles.add((ParticleOptions)((Pair)ParticleTypes.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse(jsonStr)).getOrThrow()).getFirst());
            }
            catch (Exception exception) {}
        }
        EntityData.LIVING_ENTITY_EFFECT_PARTICLES.set((Entity)entity2, particles);
        EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.set(ctx.getEntity(), this.ambience);
        return MocapAction.Result.OK;
    }
}

