/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

public class SetLivingEntityFlags
implements MocapStateAction {
    private final byte flags;

    @Nullable
    public static SetLivingEntityFlags fromEntity(Entity entity) {
        SetLivingEntityFlags setLivingEntityFlags;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            setLivingEntityFlags = new SetLivingEntityFlags(livingEntity);
        } else {
            setLivingEntityFlags = null;
        }
        return setLivingEntityFlags;
    }

    private SetLivingEntityFlags(LivingEntity entity) {
        this.flags = EntityData.LIVING_ENTITY_FLAGS.valOrDef((Entity)entity, (byte)0);
    }

    public SetLivingEntityFlags(MocapAction.Reader reader) {
        this.flags = reader.readByte();
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return this.flags != ((SetLivingEntityFlags)previousAction).flags;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.flags);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!(ctx.getEntity() instanceof LivingEntity)) {
            return MocapAction.Result.IGNORED;
        }
        EntityData.LIVING_ENTITY_FLAGS.set(ctx.getEntity(), this.flags);
        return MocapAction.Result.OK;
    }
}

