/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import org.jetbrains.annotations.Nullable;

public class SetMainHand
implements MocapStateAction {
    private final HumanoidArm mainHand;

    @Nullable
    public static SetMainHand fromEntity(Entity entity) {
        SetMainHand setMainHand;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            setMainHand = new SetMainHand(livingEntity);
        } else {
            setMainHand = null;
        }
        return setMainHand;
    }

    private SetMainHand(LivingEntity entity) {
        this.mainHand = entity.getMainArm();
    }

    public SetMainHand(MocapAction.Reader reader) {
        this.mainHand = reader.readBoolean() ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return this.mainHand != ((SetMainHand)previousAction).mainHand;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addBoolean(this.mainHand == HumanoidArm.RIGHT);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (ctx.getEntity() instanceof Player) {
            ((Player)ctx.getEntity()).setMainArm(this.mainHand);
        } else if (ctx.getEntity() instanceof Mob) {
            ((Mob)ctx.getEntity()).setLeftHanded(this.mainHand == HumanoidArm.LEFT);
        } else {
            return MocapAction.Result.IGNORED;
        }
        return MocapAction.Result.OK;
    }
}

