/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.Objects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mixin.fields.AbstractArrowFields;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.BoatFields;
import net.mt1006.mocap.mixin.fields.HorseFields;
import net.mt1006.mocap.mixin.fields.LlamaFields;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

public class SetNonPlayerEntityData
implements MocapStateAction {
    private static final byte VAL_FLAG1 = 1;
    private static final byte VAL_FLAG2 = 2;
    private static final byte HAS_BYTE1 = 4;
    private static final byte HAS_INT1 = 8;
    private static final byte HAS_INT2 = 16;
    private static final byte HAS_INT3 = 32;
    private static final byte HAS_FLOAT1 = 64;
    private final boolean flag1;
    private final boolean flag2;
    @Nullable
    private final Byte byte1;
    @Nullable
    private final Integer int1;
    @Nullable
    private final Integer int2;
    @Nullable
    private final Integer int3;
    @Nullable
    private final Float float1;

    @Nullable
    public static SetNonPlayerEntityData fromEntity(Entity entity) {
        if (entity instanceof Player) {
            return null;
        }
        if (entity instanceof AbstractHorse) {
            boolean flag1 = false;
            boolean flag2 = ((AgeableMob)entity).getAge() < 0;
            Byte byte1 = EntityData.ABSTRACT_HORSE_FLAGS.valOrDef(entity, (byte)0);
            Integer int1 = null;
            if (entity instanceof Horse) {
                int1 = ((HorseFields)entity).callGetTypeVariant();
            } else if (entity instanceof AbstractChestedHorse) {
                AbstractChestedHorse chestedHorse = (AbstractChestedHorse)entity;
                flag1 = chestedHorse.hasChest();
            } else if (entity instanceof Camel) {
                Camel camel = (Camel)entity;
                flag1 = camel.isDashing();
            }
            if (entity instanceof Llama) {
                Llama llama = (Llama)entity;
                int1 = llama.getVariant().getId();
            }
            return new SetNonPlayerEntityData(flag1, flag2, byte1, int1, null, null, null);
        }
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            return new SetNonPlayerEntityData(boat.getPaddleState(0), boat.getPaddleState(1), null, boat.getHurtTime(), boat.getHurtDir(), ((BoatFields)entity).callGetBubbleTime(), Float.valueOf(boat.getDamage()));
        }
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            return new SetNonPlayerEntityData(false, false, null, minecart.getHurtTime(), minecart.getHurtDir(), null, Float.valueOf(minecart.getDamage()));
        }
        if (entity instanceof AbstractArrow) {
            boolean flag1 = ((AbstractArrowFields)entity).callIsInGround();
            return new SetNonPlayerEntityData(flag1, false, null, null, null, null, null);
        }
        if (entity instanceof AgeableMob) {
            boolean flag2 = ((AgeableMob)entity).getAge() < 0;
            return new SetNonPlayerEntityData(false, flag2, null, null, null, null, null);
        }
        return null;
    }

    private SetNonPlayerEntityData(boolean flag1, boolean flag2, @Nullable Byte byte1, @Nullable Integer int1, @Nullable Integer int2, @Nullable Integer int3, @Nullable Float float1) {
        this.byte1 = byte1;
        this.flag1 = flag1;
        this.flag2 = flag2;
        this.int1 = int1;
        this.int2 = int2;
        this.int3 = int3;
        this.float1 = float1;
    }

    public SetNonPlayerEntityData(MocapAction.Reader reader) {
        byte flags = reader.readByte();
        this.flag1 = (flags & 1) != 0;
        this.flag2 = (flags & 2) != 0;
        this.byte1 = (flags & 4) != 0 ? Byte.valueOf(reader.readByte()) : null;
        this.int1 = (flags & 8) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.int2 = (flags & 0x10) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.int3 = (flags & 0x20) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.float1 = (flags & 0x40) != 0 ? Float.valueOf(reader.readFloat()) : null;
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        SetNonPlayerEntityData data = (SetNonPlayerEntityData)previousAction;
        return this.flag1 != data.flag1 || this.flag2 != data.flag2 || !Objects.equals(this.byte1, data.byte1) || !Objects.equals(this.int1, data.int1) || !Objects.equals(this.int2, data.int2) || !Objects.equals(this.int3, data.int3) || !Objects.equals(this.float1, data.float1);
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        byte flags = 0;
        flags = (byte)(flags | (this.flag1 ? 1 : 0));
        flags = (byte)(flags | (this.flag2 ? 2 : 0));
        flags = (byte)(flags | (this.byte1 != null ? 4 : 0));
        flags = (byte)(flags | (this.int1 != null ? 8 : 0));
        flags = (byte)(flags | (this.int2 != null ? 16 : 0));
        flags = (byte)(flags | (this.int3 != null ? 32 : 0));
        flags = (byte)(flags | (this.float1 != null ? 64 : 0));
        writer.addByte(flags);
        if (this.byte1 != null) {
            writer.addByte(this.byte1);
        }
        if (this.int1 != null) {
            writer.addPackedInt(this.int1);
        }
        if (this.int2 != null) {
            writer.addPackedInt(this.int2);
        }
        if (this.int3 != null) {
            writer.addPackedInt(this.int3);
        }
        if (this.float1 != null) {
            writer.addFloat(this.float1.floatValue());
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        Entity entity = ctx.getEntity();
        if (entity instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)entity;
            if (ageableMob.getAge() < 0) {
                ageableMob.setAge(0);
            }
            EntityData.AGEABLE_MOB_IS_BABY.set(entity, this.flag2);
        }
        if (entity instanceof AbstractHorse) {
            if (this.byte1 == null) {
                return MocapAction.Result.ERROR;
            }
            EntityData.ABSTRACT_HORSE_FLAGS.set(entity, this.byte1);
            try {
                ItemStack itemStack = new ItemStack((ItemLike)((this.byte1 & 4) != 0 ? Items.SADDLE : Items.AIR));
                ((AbstractHorseFields)entity).getInventory().setItem(0, itemStack);
            }
            catch (Exception itemStack) {
                // empty catch block
            }
            if (entity instanceof Horse) {
                ((HorseFields)entity).callSetTypeVariant(this.int1 != null ? this.int1 : 0);
            } else if (entity instanceof AbstractChestedHorse) {
                AbstractChestedHorse chestedHorse = (AbstractChestedHorse)entity;
                chestedHorse.setChest(this.flag1);
            } else if (entity instanceof Camel) {
                Camel camel = (Camel)entity;
                camel.setDashing(this.flag1);
            }
            if (entity instanceof Llama) {
                ((LlamaFields)entity).callSetVariant(Llama.Variant.byId((int)(this.int1 != null ? this.int1 : 0)));
            }
        } else if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            if (this.int1 == null || this.int2 == null || this.int3 == null || this.float1 == null) {
                return MocapAction.Result.ERROR;
            }
            boat.setPaddleState(this.flag1, this.flag2);
            boat.setHurtTime(this.int1.intValue());
            boat.setHurtDir(this.int2.intValue());
            ((BoatFields)entity).callSetBubbleTime(this.int3);
            boat.setDamage(this.float1.floatValue());
        } else if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            if (this.int1 == null || this.int2 == null || this.float1 == null) {
                return MocapAction.Result.ERROR;
            }
            minecart.setHurtTime(this.int1.intValue());
            minecart.setHurtDir(this.int2.intValue());
            minecart.setDamage(this.float1.floatValue());
        } else if (entity instanceof AbstractArrow) {
            ((AbstractArrowFields)entity).callSetInGround(this.flag1);
        }
        return MocapAction.Result.OK;
    }
}

