/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mocap.settings.Settings;

public class SetSpectator
implements MocapStateAction {
    private final boolean isSpectator;

    public SetSpectator(Entity entity) {
        this.isSpectator = entity instanceof ServerPlayer && ((ServerPlayer)entity).gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
    }

    public SetSpectator(MocapAction.Reader reader) {
        this.isSpectator = reader.readBoolean();
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return this.isSpectator != ((SetSpectator)previousAction).isSpectator;
    }

    @Override
    public boolean shouldBeInitialized() {
        return this.isSpectator;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addBoolean(this.isSpectator);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!(ctx.getEntity() instanceof ServerPlayer)) {
            return MocapAction.Result.IGNORED;
        }
        ((ServerPlayer)ctx.getEntity()).setGameMode(this.isSpectator ? GameType.SPECTATOR : ((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL));
        return MocapAction.Result.OK;
    }
}

