/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapTickAction;

public class SkipTicks
implements MocapTickAction {
    private final int number;

    public SkipTicks(int number) {
        if (number > 255) {
            throw new RuntimeException("Trying to skip more than 255 ticks!");
        }
        this.number = number;
    }

    public SkipTicks(MocapAction.Reader reader) {
        this.number = Byte.toUnsignedInt(reader.readByte());
    }

    public boolean canBeModified() {
        return this.number < 255;
    }

    public SkipTicks increment() {
        return new SkipTicks(this.number + 1);
    }

    @Override
    public int getTickCount() {
        return this.number;
    }

    @Override
    public boolean endsTick() {
        return this.number != 0;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte((byte)this.number);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (ctx.shouldStopRepeat(this.number)) {
            return MocapAction.Result.OK;
        }
        ctx.incrementRepeatCounter();
        return MocapAction.Result.REPEAT_TICK;
    }
}

