/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import org.jetbrains.annotations.Nullable;

public class Swing
implements MocapStateAction {
    private final boolean swinging;
    private final int swingingTime;
    private final InteractionHand hand;

    @Nullable
    public static Swing fromEntity(Entity entity) {
        Swing swing;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            swing = new Swing(livingEntity);
        } else {
            swing = null;
        }
        return swing;
    }

    private Swing(LivingEntity entity) {
        this.swinging = entity.swinging;
        this.swingingTime = entity.swingTime;
        this.hand = entity.swingingArm;
    }

    public Swing(MocapAction.Reader reader) {
        this.swinging = true;
        this.swingingTime = 0;
        this.hand = reader.readBoolean() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        Swing previousSwing = (Swing)previousAction;
        return this.swinging && (previousSwing == null || !previousSwing.swinging || previousSwing.swingingTime > this.swingingTime);
    }

    @Override
    public boolean shouldBeInitialized() {
        return false;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addBoolean(this.hand == InteractionHand.OFF_HAND);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!(ctx.getEntity() instanceof LivingEntity)) {
            return MocapAction.Result.IGNORED;
        }
        ((LivingEntity)ctx.getEntity()).swing(this.hand);
        return MocapAction.Result.OK;
    }
}

