/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions.deprecated;

import java.util.Set;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;

public class MovementLegacy
implements MocapAction {
    private final Vec3 position;
    private final float[] rotation = new float[2];
    private final boolean isOnGround;

    public MovementLegacy(MocapAction.Reader reader) {
        this.position = reader.readVec3();
        this.rotation[0] = reader.readFloat();
        this.rotation[1] = reader.readFloat();
        this.isOnGround = reader.readBoolean();
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        throw new RuntimeException("Trying to save deprecated action!");
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        Entity entity = ctx.getEntity();
        Vec3 oldPos = entity.position();
        ctx.changePosition(ctx.getPosition().add(this.position), this.rotation[1], this.rotation[0], true);
        entity.setOnGround(this.isOnGround);
        entity.applyEffectsFromBlocks(oldPos, entity.position());
        ctx.fluentMovement(() -> new ClientboundTeleportEntityPacket(entity.getId(), PositionMoveRotation.of((Entity)entity), Set.of(), this.isOnGround));
        return MocapAction.Result.OK;
    }
}

