/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions.deprecated;

import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.BoatFields;
import net.mt1006.mocap.mixin.fields.HorseFields;
import net.mt1006.mocap.mixin.fields.LlamaFields;
import net.mt1006.mocap.utils.EntityData;

public class SetVehicleData
implements MocapAction {
    private final boolean used;
    private final byte flags;
    private final boolean flag1;
    private final boolean flag2;
    private final int int1;
    private final int int2;
    private final int int3;
    private final float float1;

    public SetVehicleData(MocapAction.Reader reader) {
        this.used = reader.readBoolean();
        this.flags = this.used ? reader.readByte() : (byte)0;
        this.flag1 = this.used && reader.readBoolean();
        this.flag2 = this.used && reader.readBoolean();
        this.int1 = this.used ? reader.readInt() : 0;
        this.int2 = this.used ? reader.readInt() : 0;
        this.int3 = this.used ? reader.readInt() : 0;
        this.float1 = this.used ? reader.readFloat() : 0.0f;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addBoolean(this.used);
        if (this.used) {
            writer.addByte(this.flags);
            writer.addBoolean(this.flag1);
            writer.addBoolean(this.flag2);
            writer.addInt(this.int1);
            writer.addInt(this.int2);
            writer.addInt(this.int3);
            writer.addFloat(this.float1);
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!this.used) {
            return MocapAction.Result.IGNORED;
        }
        Entity entity = ctx.getEntity();
        if (entity instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)entity;
            ageableMob.setAge(this.flag2 ? -1 : 0);
        }
        if (entity instanceof AbstractHorse) {
            EntityData.ABSTRACT_HORSE_FLAGS.set(entity, this.flags);
            try {
                ItemStack itemStack = new ItemStack((ItemLike)((this.flags & 4) != 0 ? Items.SADDLE : Items.AIR));
                ((AbstractHorseFields)entity).getInventory().setItem(0, itemStack);
            }
            catch (Exception itemStack) {
                // empty catch block
            }
            if (entity instanceof Horse) {
                ((HorseFields)entity).callSetTypeVariant(this.int1);
            } else if (entity instanceof AbstractChestedHorse) {
                AbstractChestedHorse chestedHorse = (AbstractChestedHorse)entity;
                chestedHorse.setChest(this.flag1);
            } else if (entity instanceof Camel) {
                Camel camel = (Camel)entity;
                camel.setDashing(this.flag1);
            }
            if (entity instanceof Llama) {
                ((LlamaFields)entity).callSetVariant(Llama.Variant.byId((int)this.int1));
            }
        } else if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.setPaddleState(this.flag1, this.flag2);
            boat.setHurtTime(this.int1);
            boat.setHurtDir(this.int2);
            ((BoatFields)entity).callSetBubbleTime(this.int3);
            boat.setDamage(this.float1);
        } else if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            minecart.setHurtTime(this.int1);
            minecart.setHurtDir(this.int2);
            minecart.setDamage(this.float1);
        }
        return MocapAction.Result.OK;
    }
}

