/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.controller.config.MocapDimensionSource;
import net.mt1006.mocap.api.v1.controller.playable.MocapRecordingFile;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingFiles {
    public static final byte VERSION = 5;
    private static final int ALT_NAME_MAX_I = 128;
    public static final MocapAction.Reader DUMMY_READER = new DummyReader();

    public static boolean save(CommandOutput out, File recordingFile, String name, RecordingData data) {
        try {
            if (recordingFile.exists()) {
                out.sendFailure("recording.save.already_exists", new Object[0]);
                return false;
            }
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(recordingFile));
            data.save(stream);
            stream.close();
        }
        catch (IOException e) {
            out.sendException(e, "recording.save.error", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.add(name);
        return true;
    }

    public static boolean info(CommandInfo out, @Nullable RecordingFile file) {
        RecordingFile.Info info = RecordingFile.Info.load(out, file);
        if (file == null || info == null) {
            return false;
        }
        out.sendSuccess("recordings.info.info", new Object[0]);
        out.sendSuccess("file.info.name", file.getName());
        if (!Files.printVersionInfo(out, 5, info.version(), info.experimental(), info.experimentalSubversion())) {
            return true;
        }
        out.sendSuccess("recordings.info.length", String.format("%.2f", (double)info.lengthInTicks() / 20.0), info.lengthInTicks());
        out.sendSuccess("recordings.info.size", String.format("%.2f", (double)info.sizeInBytes() / 1024.0), info.sizeInOps());
        RecordingFiles.printPosInfo(out, info);
        if (info.assignedDimensionId() != null) {
            out.sendSuccess("recordings.info.dimension", info.assignedDimensionId().toString());
        } else {
            out.sendSuccess("recordings.info.dimension.not_assigned", new Object[0]);
        }
        if (info.assignedPlayerName() != null) {
            out.sendSuccess("recordings.info.player_name_assigned.yes", info.assignedPlayerName());
        } else {
            out.sendSuccess("recordings.info.player_name_assigned.no", new Object[0]);
        }
        out.sendSuccess(info.legacyEndsWithDeath() ? "recordings.info.dies.yes" : "recordings.info.dies.no", new Object[0]);
        return true;
    }

    private static void printPosInfo(CommandInfo out, MocapRecordingFile.Info info) {
        ResourceLocation dimensionId = info.assignedDimensionId();
        boolean anotherDimension = dimensionId != null && out.getLevel().dimension() != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionId) && (Settings.DIMENSION_SOURCE.val == MocapDimensionSource.ASSIGNED_OR_CURRENT || Settings.DIMENSION_SOURCE.val == MocapDimensionSource.ASSIGNED_OR_OVERWORLD);
        String xStr = String.format(Locale.US, "%.2f", info.startPos().x);
        String yStr = String.format(Locale.US, "%.2f", info.startPos().y);
        String zStr = String.format(Locale.US, "%.2f", info.startPos().z);
        String command = anotherDimension ? String.format("/execute in %s run tp @p %s %s %s", dimensionId, xStr, yStr, zStr) : String.format("/tp @p %s %s %s", xStr, yStr, zStr);
        Object text = String.format("%s %s %s", xStr, yStr, zStr);
        if (anotherDimension) {
            String dimensionIdStr = dimensionId.getNamespace().equals("minecraft") ? dimensionId.getPath() : dimensionId.toString();
            text = (String)text + String.format(" (%s)", dimensionIdStr);
        }
        MutableComponent tpSuggestionComponent = Utils.getSuggestCommandComponent(command, Component.literal((String)text)).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
        out.sendSuccess("recordings.info.start_pos", tpSuggestionComponent);
    }

    @Nullable
    public static List<String> list() {
        if (!Files.initialized) {
            return null;
        }
        String[] fileList = Files.recordingsDirectory.list(Files::isRecordingFile);
        if (fileList == null) {
            return null;
        }
        ArrayList<String> recordings = new ArrayList<String>(fileList.length);
        for (String filename : fileList) {
            recordings.add(filename.substring(0, filename.lastIndexOf(46)));
        }
        Collections.sort(recordings);
        return recordings;
    }

    @Nullable
    public static String findAlternativeName(String name) {
        char ch;
        int lastDigit;
        if (name.isEmpty()) {
            return null;
        }
        int firstDigit = name.length();
        int i = lastDigit = name.length() - 1;
        while (i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9') {
            firstDigit = i--;
        }
        if (firstDigit > lastDigit) {
            return null;
        }
        String prefix = name.substring(0, firstDigit);
        int suffix = Integer.parseInt(name.substring(firstDigit, lastDigit + 1));
        for (int i2 = suffix + 1; i2 <= suffix + 128; ++i2) {
            String possibleName = String.format("%s%d", prefix, i2);
            if (CommandSuggestions.inputSet.contains(possibleName)) continue;
            return possibleName;
        }
        return null;
    }

    private static class DummyReader
    implements MocapAction.Reader {
        private static final UUID UUID_ZERO = new UUID(0L, 0L);

        private DummyReader() {
        }

        @Override
        public byte readByte() {
            return 0;
        }

        @Override
        public short readShort() {
            return 0;
        }

        @Override
        public int readInt() {
            return 0;
        }

        @Override
        public long readLong() {
            return 0L;
        }

        @Override
        public float readFloat() {
            return 0.0f;
        }

        @Override
        public double readDouble() {
            return 0.0;
        }

        @Override
        public boolean readBoolean() {
            return false;
        }

        @Override
        public String readString() {
            return "";
        }

        @Override
        public UUID readUUID() {
            return UUID_ZERO;
        }

        @Override
        public Vec3 readVec3() {
            return Vec3.ZERO;
        }

        @Override
        public BlockPos readBlockPos() {
            return BlockPos.ZERO;
        }

        @Override
        public int readPackedInt() {
            return 0;
        }

        @Override
        public void shift(int val) {
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }

    public static class FileReader
    implements MocapAction.Reader {
        private final byte[] recording;
        private boolean legacyString;
        public int offset = 0;
        public boolean convertStrings = false;

        public FileReader(byte[] recording, boolean legacyString) {
            this.recording = recording;
            this.legacyString = legacyString;
        }

        @Override
        public byte readByte() {
            return this.recording[this.offset++];
        }

        @Override
        public short readShort() {
            short retVal = (short)((this.recording[this.offset] & 0xFF) << 8 | this.recording[this.offset + 1] & 0xFF);
            this.offset += 2;
            return retVal;
        }

        @Override
        public int readInt() {
            int retVal = (this.recording[this.offset] & 0xFF) << 24 | (this.recording[this.offset + 1] & 0xFF) << 16 | (this.recording[this.offset + 2] & 0xFF) << 8 | this.recording[this.offset + 3] & 0xFF;
            this.offset += 4;
            return retVal;
        }

        @Override
        public long readLong() {
            long retVal = ((long)this.recording[this.offset] & 0xFFL) << 56 | ((long)this.recording[this.offset + 1] & 0xFFL) << 48 | ((long)this.recording[this.offset + 2] & 0xFFL) << 40 | ((long)this.recording[this.offset + 3] & 0xFFL) << 32 | ((long)this.recording[this.offset + 4] & 0xFFL) << 24 | ((long)this.recording[this.offset + 5] & 0xFFL) << 16 | ((long)this.recording[this.offset + 6] & 0xFFL) << 8 | (long)this.recording[this.offset + 7] & 0xFFL;
            this.offset += 8;
            return retVal;
        }

        @Override
        public float readFloat() {
            float retVal = FileReader.byteArrayToFloat(Arrays.copyOfRange(this.recording, this.offset, this.offset + 4));
            this.offset += 4;
            return retVal;
        }

        @Override
        public double readDouble() {
            double retVal = FileReader.byteArrayToDouble(Arrays.copyOfRange(this.recording, this.offset, this.offset + 8));
            this.offset += 8;
            return retVal;
        }

        @Override
        public boolean readBoolean() {
            return this.recording[this.offset++] == 1;
        }

        @Override
        public String readString() {
            if (this.convertStrings && !this.legacyString) {
                return this.readAlphaString();
            }
            int len = this.legacyString ? this.readInt() : this.readPackedInt();
            String str = new String(this.recording, this.offset, len, StandardCharsets.UTF_8);
            this.offset += len;
            return str;
        }

        @Override
        public UUID readUUID() {
            return new UUID(this.readLong(), this.readLong());
        }

        private String readAlphaString() {
            int termPos = -1;
            for (int i = this.offset; i < this.recording.length; ++i) {
                if (this.recording[i] != 0) continue;
                termPos = i;
                break;
            }
            int len = termPos - this.offset;
            String str = new String(this.recording, this.offset, len, StandardCharsets.UTF_8);
            this.offset += len + 1;
            return str;
        }

        @Override
        public Vec3 readVec3() {
            return new Vec3(this.readDouble(), this.readDouble(), this.readDouble());
        }

        @Override
        public BlockPos readBlockPos() {
            return new BlockPos(this.readInt(), this.readInt(), this.readInt());
        }

        @Override
        public int readPackedInt() {
            int val = Byte.toUnsignedInt(this.readByte());
            return val == 255 ? this.readInt() : val;
        }

        @Override
        public void shift(int val) {
            this.offset += val;
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        public void setStringMode(boolean legacyString) {
            this.legacyString = legacyString;
        }

        public boolean canRead() {
            return this.recording.length > this.offset;
        }

        public int getSize() {
            return this.recording.length;
        }

        private static float byteArrayToFloat(byte[] bytes) {
            int bits = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return Float.intBitsToFloat(bits);
        }

        private static double byteArrayToDouble(byte[] bytes) {
            long bits = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
            return Double.longBitsToDouble(bits);
        }
    }

    public static class Writer
    implements MocapAction.Writer {
        private final ArrayList<Byte> recording = new ArrayList();

        @Override
        public void addByte(byte val) {
            this.recording.add(val);
        }

        @Override
        public void addShort(short val) {
            this.recording.add((byte)(val >> 8));
            this.recording.add((byte)val);
        }

        @Override
        public void addInt(int val) {
            this.recording.add((byte)(val >> 24));
            this.recording.add((byte)(val >> 16));
            this.recording.add((byte)(val >> 8));
            this.recording.add((byte)val);
        }

        @Override
        public void addLong(long val) {
            this.recording.add((byte)(val >> 56));
            this.recording.add((byte)(val >> 48));
            this.recording.add((byte)(val >> 40));
            this.recording.add((byte)(val >> 32));
            this.recording.add((byte)(val >> 24));
            this.recording.add((byte)(val >> 16));
            this.recording.add((byte)(val >> 8));
            this.recording.add((byte)val);
        }

        @Override
        public void addFloat(float val) {
            for (byte b : Writer.floatToByteArray(val)) {
                this.recording.add(b);
            }
        }

        @Override
        public void addDouble(double val) {
            for (byte b : Writer.doubleToByteArray(val)) {
                this.recording.add(b);
            }
        }

        @Override
        public void addBoolean(boolean val) {
            this.recording.add(val ? (byte)1 : 0);
        }

        @Override
        public void addString(String val) {
            byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
            this.addPackedInt(bytes.length);
            for (byte b : bytes) {
                this.recording.add(b);
            }
        }

        @Override
        public void addUUID(UUID val) {
            this.addLong(val.getMostSignificantBits());
            this.addLong(val.getLeastSignificantBits());
        }

        @Override
        public void addVec3(Vec3 vec) {
            this.addDouble(vec.x);
            this.addDouble(vec.y);
            this.addDouble(vec.z);
        }

        @Override
        public void addBlockPos(BlockPos blockPos) {
            this.addInt(blockPos.getX());
            this.addInt(blockPos.getY());
            this.addInt(blockPos.getZ());
        }

        @Override
        public void addPackedInt(int size) {
            if (size >= 0 && size < 255) {
                this.addByte((byte)size);
            } else {
                this.addByte((byte)-1);
                this.addInt(size);
            }
        }

        public void copyToWriter(MocapAction.Writer writer) {
            this.recording.forEach(writer::addByte);
        }

        public int getSize() {
            return this.recording.size();
        }

        public byte[] toByteArray() {
            byte[] array = new byte[this.recording.size()];
            for (int i = 0; i < this.recording.size(); ++i) {
                array[i] = this.recording.get(i);
            }
            return array;
        }

        private static byte[] floatToByteArray(float val) {
            int bits = Float.floatToIntBits(val);
            return new byte[]{(byte)(bits >> 24), (byte)(bits >> 16), (byte)(bits >> 8), (byte)bits};
        }

        private static byte[] doubleToByteArray(double val) {
            long bits = Double.doubleToLongBits(val);
            return new byte[]{(byte)(bits >> 56), (byte)(bits >> 48), (byte)(bits >> 40), (byte)(bits >> 32), (byte)(bits >> 24), (byte)(bits >> 16), (byte)(bits >> 8), (byte)bits};
        }
    }
}

