/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.mt1006.mocap.api.v1.controller.playable.MocapPlayable;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneElement;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.LegacySceneDataParser;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playable.SceneFile;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class SceneData {
    public final List<MocapSceneElement> elements = new ArrayList<MocapSceneElement>();
    public int version = 0;
    public boolean experimentalVersion = false;
    public long fileSize = 0L;

    public static SceneData empty() {
        SceneData sceneData = new SceneData();
        sceneData.version = 4;
        sceneData.experimentalVersion = true;
        return sceneData;
    }

    public boolean save(CommandOutput out, SceneFile file, String sceneName, String onSuccess, String onError) {
        JsonObject json = new JsonObject();
        json.add("version", (JsonElement)new JsonPrimitive((Number)(this.experimentalVersion ? -this.version : this.version)));
        JsonArray subscenesArray = new JsonArray();
        this.elements.forEach(s -> subscenesArray.add((JsonElement)s.toJson()));
        json.add("subscenes", (JsonElement)subscenesArray);
        try {
            FileWriter writer = new FileWriter(file.getFile());
            GsonBuilder gsonBuilder = (Boolean)Settings.PRETTY_SCENE_FILES.val != false ? new GsonBuilder().setPrettyPrinting() : new GsonBuilder();
            gsonBuilder.create().toJson((JsonElement)json, (Appendable)writer);
            writer.close();
            this.saveToSceneElementCache(sceneName);
            out.sendSuccess(onSuccess, new Object[0]);
            return true;
        }
        catch (Exception e) {
            out.sendException(e, onError, new Object[0]);
            return false;
        }
    }

    public boolean load(CommandOutput out, @Nullable SceneFile file) {
        if (file == null) {
            return false;
        }
        byte[] data = Files.loadFile(file.getFile());
        return data != null && this.load(out, data);
    }

    private boolean load(CommandOutput out, byte[] scene) {
        this.fileSize = scene.length;
        LegacySceneDataParser legacyParser = new LegacySceneDataParser(this, out, scene);
        if (legacyParser.isLegacy()) {
            return legacyParser.wasParsed();
        }
        try {
            JsonElement jsonElement = new JsonParser().parse((Reader)new InputStreamReader(new ByteArrayInputStream(scene)));
            JsonObject json = jsonElement.getAsJsonObject();
            if (json == null) {
                throw new Exception("Scene file isn't a JSON object!");
            }
            JsonElement versionElement = json.get("version");
            if (versionElement == null) {
                throw new Exception("Scene version not specified!");
            }
            if (!this.setAndVerifyVersion(out, versionElement.getAsInt())) {
                return false;
            }
            JsonElement subsceneArrayElement = json.get("subscenes");
            if (subsceneArrayElement == null) {
                throw new Exception("Scene subscenes list not found!");
            }
            for (JsonElement subsceneElement : subsceneArrayElement.getAsJsonArray()) {
                JsonObject subsceneObject = subsceneElement.getAsJsonObject();
                if (subsceneObject == null) {
                    throw new Exception("Scene subscene isn't a JSON object!");
                }
                this.elements.add(new Element(subsceneObject));
            }
            return true;
        }
        catch (Exception e) {
            return out.sendException(e, "error.failed_to_load_scene", new Object[0]);
        }
    }

    public boolean setAndVerifyVersion(CommandOutput out, int versionNumber) {
        this.version = Math.abs(versionNumber);
        boolean bl = this.experimentalVersion = versionNumber < 0;
        if (this.version > 4) {
            out.sendFailure("error.failed_to_load_scene", new Object[0]);
            out.sendFailure("error.failed_to_load_scene.not_supported", new Object[0]);
            return false;
        }
        return true;
    }

    @Nullable
    public List<String> saveToSceneElementCache(String sceneName) {
        ArrayList<String> elements = new ArrayList<String>(this.elements.size());
        int id = 1;
        for (MocapSceneElement element : this.elements) {
            elements.add(String.format("%03d-%s", id, element.getName()));
            ++id;
        }
        CommandSuggestions.sceneElementCache.put(sceneName, elements);
        return elements;
    }

    @Nullable
    public static MocapSceneElement loadSubscene(CommandOutput out, @Nullable SceneData sceneData, Pair<Integer, @Nullable String> pair) {
        return SceneData.loadSubscene(out, sceneData, (Integer)pair.getFirst(), (String)pair.getSecond());
    }

    @Nullable
    public static MocapSceneElement loadSubscene(CommandOutput out, @Nullable SceneData sceneData, int pos, @Nullable String expectedName) {
        if (sceneData == null) {
            return null;
        }
        if (sceneData.elements.size() < pos || pos < 1) {
            out.sendFailureWithTip("scenes.failure.wrong_element_pos", new Object[0]);
            return null;
        }
        MocapSceneElement element = sceneData.elements.get(pos - 1);
        if (expectedName != null && !expectedName.equals(element.getName())) {
            out.sendFailure("scenes.failure.wrong_subscene_name", new Object[0]);
            return null;
        }
        return element;
    }

    public static class Element
    implements MocapSceneElement {
        public final String name;
        public final MocapModifiers modifiers;

        public Element(String name, MocapModifiers modifiers) {
            this.name = name;
            this.modifiers = modifiers;
        }

        public Element(JsonObject json) throws Exception {
            JsonElement nameElement = json.get("name");
            if (nameElement == null) {
                throw new Exception("JSON \"name\" element not found!");
            }
            this.name = nameElement.getAsString();
            this.modifiers = new PlaybackModifiers(new SceneFiles.Reader(json));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public MocapSceneElement withName(String name) {
            return new Element(name, this.modifiers);
        }

        @Override
        public MocapModifiers getModifiers() {
            return this.modifiers;
        }

        @Override
        public MocapSceneElement withModifiers(MocapModifiers modifiers) {
            return new Element(this.name, modifiers);
        }

        @Override
        @Nullable
        public MocapPlayable getPlayable(CommandInfo info) {
            return MocapPlayable.get(info, this.name);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("name", (JsonElement)new JsonPrimitive(this.name));
            this.modifiers.save(new SceneFiles.Writer(json));
            return json;
        }
    }
}

