/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerAsEntity;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerAsEntity
implements MocapPlayerAsEntity {
    public static final PlayerAsEntity DISABLED = new PlayerAsEntity(null, null);
    @Nullable
    private final String entityId;
    @Nullable
    public final String entityNbt;
    @Nullable
    private final EntityType<?> entityType;
    @Nullable
    private final CompoundTag compoundTag;

    public PlayerAsEntity(@Nullable String entityId, @Nullable String entityNbt) {
        this.entityId = entityId;
        this.entityNbt = entityNbt;
        this.entityType = PlayerAsEntity.prepareEntityType(entityId, entityNbt);
        this.compoundTag = PlayerAsEntity.prepareCompoundTag(entityId, entityNbt);
    }

    public static PlayerAsEntity fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new PlayerAsEntity(reader.readString("id"), reader.readString("nbt")) : DISABLED;
    }

    @Override
    public boolean isEnabled() {
        return this.entityId != null;
    }

    @Override
    @Nullable
    public ResourceLocation getEntityId() {
        return this.entityId != null ? ResourceLocation.tryParse((String)this.entityId) : null;
    }

    @Override
    @Nullable
    public EntityType<?> getEntityType() {
        ResourceLocation id = this.getEntityId();
        if (id == null || !BuiltInRegistries.ENTITY_TYPE.containsKey(id)) {
            return null;
        }
        Holder.Reference entityTypeRef = BuiltInRegistries.ENTITY_TYPE.get(id).orElse(null);
        return entityTypeRef != null ? (EntityType)entityTypeRef.value() : null;
    }

    @Override
    @Nullable
    public String getRawEntityId() {
        return this.entityId;
    }

    @Override
    @Nullable
    public String getNbt() {
        return this.entityNbt;
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (!this.isEnabled()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addString("id", this.entityId);
        writer.addString("nbt", this.entityNbt);
        return writer;
    }

    @Override
    @Nullable
    public Entity createEntity(Level level) {
        if (this.entityType == null && this.compoundTag == null) {
            return null;
        }
        ValueInput nbt = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.compoundTag);
        return this.compoundTag != null ? (Entity)EntityType.create((ValueInput)nbt, (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND).orElse(null) : this.entityType.create(level, EntitySpawnReason.COMMAND);
    }

    @Nullable
    private static EntityType<?> prepareEntityType(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt != null) {
            return null;
        }
        ResourceLocation entityRes = ResourceLocation.parse((String)entityId);
        Holder.Reference entityTypeRef = BuiltInRegistries.ENTITY_TYPE.get(entityRes).orElse(null);
        return entityTypeRef != null ? (EntityType)entityTypeRef.value() : null;
    }

    @Nullable
    private static CompoundTag prepareCompoundTag(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt == null) {
            return null;
        }
        try {
            CompoundTag nbt = Utils.nbtFromString(entityNbt);
            nbt.putString("id", entityId);
            return nbt;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }
}

