/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import java.lang.runtime.SwitchBootstraps;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapTime;
import net.mt1006.mocap.api.v1.modifiers.MocapTimeModifiers;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.SceneFiles;
import org.jetbrains.annotations.Nullable;

public class TimeModifiers
implements MocapTimeModifiers {
    public static final TimeModifiers DEFAULT = new TimeModifiers(MocapTime.ZERO, MocapTime.ZERO, MocapTime.ZERO, true, false);
    private final MocapTime startDelay;
    private final MocapTime waitOnStart;
    private final MocapTime waitOnEnd;
    private final boolean waitForParentEnd;
    private final boolean loop;

    private TimeModifiers(MocapTime startDelay, MocapTime waitOnStart, MocapTime waitOnEnd, boolean waitForParentEnd, boolean loop) {
        this.startDelay = startDelay;
        this.waitOnStart = waitOnStart;
        this.waitOnEnd = waitOnEnd;
        this.waitForParentEnd = waitForParentEnd;
        this.loop = loop;
    }

    private TimeModifiers(SceneFiles.Reader reader) {
        this.startDelay = MocapTime.fromSeconds(reader.readDouble("start_delay", 0.0));
        this.waitOnStart = MocapTime.fromSeconds(reader.readDouble("wait_on_start", 0.0));
        this.waitOnEnd = MocapTime.fromSeconds(reader.readDouble("wait_on_end", 0.0));
        this.waitForParentEnd = reader.readBoolean("wait_for_parent_end", true);
        this.loop = reader.readBoolean("loop", false);
    }

    public static TimeModifiers fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new TimeModifiers(reader) : DEFAULT;
    }

    public static MocapTimeModifiers fromLegacyScene(double waitOnStart) {
        return DEFAULT.withWaitOnStart(MocapTime.fromSeconds(waitOnStart));
    }

    @Override
    public MocapTime getStartDelay() {
        return this.startDelay;
    }

    @Override
    public MocapTimeModifiers withStartDelay(MocapTime val) {
        return new TimeModifiers(val, this.waitOnStart, this.waitOnEnd, this.waitForParentEnd, this.loop);
    }

    @Override
    public MocapTime getWaitOnStart() {
        return this.waitOnStart;
    }

    @Override
    public MocapTimeModifiers withWaitOnStart(MocapTime val) {
        return new TimeModifiers(this.startDelay, val, this.waitOnEnd, this.waitForParentEnd, this.loop);
    }

    @Override
    public MocapTime getWaitOnEnd() {
        return this.waitOnEnd;
    }

    @Override
    public MocapTimeModifiers withWaitOnEnd(MocapTime val) {
        return new TimeModifiers(this.startDelay, this.waitOnStart, val, this.waitForParentEnd, this.loop);
    }

    @Override
    public boolean getWaitForParentEnd() {
        return this.waitForParentEnd;
    }

    @Override
    public MocapTimeModifiers withWaitForParentEnd(boolean val) {
        return new TimeModifiers(this.startDelay, this.waitOnStart, this.waitOnEnd, val, this.loop);
    }

    @Override
    public boolean getLoop() {
        return this.loop;
    }

    @Override
    public MocapTimeModifiers withLoop(boolean val) {
        return new TimeModifiers(this.startDelay, this.waitOnStart, this.waitOnEnd, this.waitForParentEnd, val);
    }

    @Override
    public int getWaitTicksSum() {
        return this.startDelay.ticks + this.waitOnStart.ticks;
    }

    @Override
    public boolean areDefault() {
        return this.startDelay.ticks == 0 && this.waitOnStart.ticks == 0 && this.waitOnEnd.ticks == 0 && this.waitForParentEnd && !this.loop;
    }

    @Override
    public MocapTimeModifiers mergeWithParent(MocapTimeModifiers parent) {
        return new TimeModifiers(this.startDelay.add(parent.getStartDelay()), this.waitOnStart.add(parent.getWaitOnStart()), this.waitOnEnd, this.waitForParentEnd, this.loop);
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (this.areDefault()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addDouble("start_delay", this.startDelay.seconds, 0.0);
        writer.addDouble("wait_on_start", this.waitOnStart.seconds, 0.0);
        writer.addDouble("wait_on_end", this.waitOnEnd.seconds, 0.0);
        writer.addBoolean("wait_for_parent_end", this.waitForParentEnd, true);
        writer.addBoolean("loop", this.loop, false);
        return writer;
    }

    @Override
    public void list(CommandOutput out) {
        out.sendSuccess("scenes.element_info.time.start_delay", this.startDelay.seconds, this.startDelay.ticks);
        out.sendSuccess("scenes.element_info.time.wait_on_start", this.waitOnStart.seconds, this.waitOnStart.ticks);
        out.sendSuccess("scenes.element_info.time.wait_on_end", this.waitOnEnd.seconds, this.waitOnEnd.ticks);
        out.sendSuccess("scenes.element_info.time.wait_for_parent_end." + this.waitForParentEnd, new Object[0]);
        out.sendSuccess("scenes.element_info.time.loop." + this.loop, new Object[0]);
    }

    @Override
    @Nullable
    public MocapTimeModifiers modify(FullCommandInfo info, int propertyNodePos) {
        String string = info.getNode(propertyNodePos);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"start_delay", "wait_on_start", "wait_on_end", "wait_for_parent_end", "loop"}, (Object)string, n)) {
            case 0: {
                return this.withStartDelay(MocapTime.fromSeconds(info.getDouble("seconds")));
            }
            case 1: {
                return this.withWaitOnStart(MocapTime.fromSeconds(info.getDouble("seconds")));
            }
            case 2: {
                return this.withWaitOnEnd(MocapTime.fromSeconds(info.getDouble("seconds")));
            }
            case 3: {
                return this.withWaitForParentEnd(info.getBool("wait_for_parent_end"));
            }
            case 4: {
                return this.withLoop(info.getBool("loop"));
            }
        }
        return null;
    }
}

